/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings for a push notification activity in a journey. This type of activity sends a push notification
 * to participants.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PushMessageActivity implements SdkPojo, Serializable,
        ToCopyableBuilder<PushMessageActivity.Builder, PushMessageActivity> {
    private static final SdkField<JourneyPushMessage> MESSAGE_CONFIG_FIELD = SdkField
            .<JourneyPushMessage> builder(MarshallingType.SDK_POJO).memberName("MessageConfig")
            .getter(getter(PushMessageActivity::messageConfig)).setter(setter(Builder::messageConfig))
            .constructor(JourneyPushMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfig").build()).build();

    private static final SdkField<String> NEXT_ACTIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextActivity").getter(getter(PushMessageActivity::nextActivity)).setter(setter(Builder::nextActivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextActivity").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(PushMessageActivity::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> TEMPLATE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateVersion").getter(getter(PushMessageActivity::templateVersion))
            .setter(setter(Builder::templateVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_CONFIG_FIELD,
            NEXT_ACTIVITY_FIELD, TEMPLATE_NAME_FIELD, TEMPLATE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final JourneyPushMessage messageConfig;

    private final String nextActivity;

    private final String templateName;

    private final String templateVersion;

    private PushMessageActivity(BuilderImpl builder) {
        this.messageConfig = builder.messageConfig;
        this.nextActivity = builder.nextActivity;
        this.templateName = builder.templateName;
        this.templateVersion = builder.templateVersion;
    }

    /**
     * <p>
     * Specifies the time to live (TTL) value for push notifications that are sent to participants in a journey.
     * </p>
     * 
     * @return Specifies the time to live (TTL) value for push notifications that are sent to participants in a journey.
     */
    public final JourneyPushMessage messageConfig() {
        return messageConfig;
    }

    /**
     * <p>
     * The unique identifier for the next activity to perform, after the message is sent.
     * </p>
     * 
     * @return The unique identifier for the next activity to perform, after the message is sent.
     */
    public final String nextActivity() {
        return nextActivity;
    }

    /**
     * <p>
     * The name of the push notification template to use for the message. If specified, this value must match the name
     * of an existing message template.
     * </p>
     * 
     * @return The name of the push notification template to use for the message. If specified, this value must match
     *         the name of an existing message template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The unique identifier for the version of the push notification template to use for the message. If specified,
     * this value must match the identifier for an existing template version. To retrieve a list of versions and version
     * identifiers for a template, use the <link linkend="templates-template-name-template-type-versions">Template
     * Versions</link> resource.
     * </p>
     * <p>
     * If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template.
     * The <i>active version</i> is typically the version of a template that's been most recently reviewed and approved
     * for use, depending on your workflow. It isn't necessarily the latest version of a template.
     * </p>
     * 
     * @return The unique identifier for the version of the push notification template to use for the message. If
     *         specified, this value must match the identifier for an existing template version. To retrieve a list of
     *         versions and version identifiers for a template, use the <link
     *         linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p>
     *         <p>
     *         If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the
     *         template. The <i>active version</i> is typically the version of a template that's been most recently
     *         reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a
     *         template.
     */
    public final String templateVersion() {
        return templateVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(nextActivity());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushMessageActivity)) {
            return false;
        }
        PushMessageActivity other = (PushMessageActivity) obj;
        return Objects.equals(messageConfig(), other.messageConfig()) && Objects.equals(nextActivity(), other.nextActivity())
                && Objects.equals(templateName(), other.templateName())
                && Objects.equals(templateVersion(), other.templateVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PushMessageActivity").add("MessageConfig", messageConfig()).add("NextActivity", nextActivity())
                .add("TemplateName", templateName()).add("TemplateVersion", templateVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageConfig":
            return Optional.ofNullable(clazz.cast(messageConfig()));
        case "NextActivity":
            return Optional.ofNullable(clazz.cast(nextActivity()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "TemplateVersion":
            return Optional.ofNullable(clazz.cast(templateVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MessageConfig", MESSAGE_CONFIG_FIELD);
        map.put("NextActivity", NEXT_ACTIVITY_FIELD);
        map.put("TemplateName", TEMPLATE_NAME_FIELD);
        map.put("TemplateVersion", TEMPLATE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PushMessageActivity, T> g) {
        return obj -> g.apply((PushMessageActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PushMessageActivity> {
        /**
         * <p>
         * Specifies the time to live (TTL) value for push notifications that are sent to participants in a journey.
         * </p>
         * 
         * @param messageConfig
         *        Specifies the time to live (TTL) value for push notifications that are sent to participants in a
         *        journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageConfig(JourneyPushMessage messageConfig);

        /**
         * <p>
         * Specifies the time to live (TTL) value for push notifications that are sent to participants in a journey.
         * </p>
         * This is a convenience method that creates an instance of the {@link JourneyPushMessage.Builder} avoiding the
         * need to create one manually via {@link JourneyPushMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JourneyPushMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #messageConfig(JourneyPushMessage)}.
         * 
         * @param messageConfig
         *        a consumer that will call methods on {@link JourneyPushMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageConfig(JourneyPushMessage)
         */
        default Builder messageConfig(Consumer<JourneyPushMessage.Builder> messageConfig) {
            return messageConfig(JourneyPushMessage.builder().applyMutation(messageConfig).build());
        }

        /**
         * <p>
         * The unique identifier for the next activity to perform, after the message is sent.
         * </p>
         * 
         * @param nextActivity
         *        The unique identifier for the next activity to perform, after the message is sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextActivity(String nextActivity);

        /**
         * <p>
         * The name of the push notification template to use for the message. If specified, this value must match the
         * name of an existing message template.
         * </p>
         * 
         * @param templateName
         *        The name of the push notification template to use for the message. If specified, this value must match
         *        the name of an existing message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The unique identifier for the version of the push notification template to use for the message. If specified,
         * this value must match the identifier for an existing template version. To retrieve a list of versions and
         * version identifiers for a template, use the <link
         * linkend="templates-template-name-template-type-versions">Template Versions</link> resource.
         * </p>
         * <p>
         * If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the
         * template. The <i>active version</i> is typically the version of a template that's been most recently reviewed
         * and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.
         * </p>
         * 
         * @param templateVersion
         *        The unique identifier for the version of the push notification template to use for the message. If
         *        specified, this value must match the identifier for an existing template version. To retrieve a list
         *        of versions and version identifiers for a template, use the <link
         *        linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p>
         *        <p>
         *        If you don't specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the
         *        template. The <i>active version</i> is typically the version of a template that's been most recently
         *        reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of
         *        a template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateVersion(String templateVersion);
    }

    static final class BuilderImpl implements Builder {
        private JourneyPushMessage messageConfig;

        private String nextActivity;

        private String templateName;

        private String templateVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(PushMessageActivity model) {
            messageConfig(model.messageConfig);
            nextActivity(model.nextActivity);
            templateName(model.templateName);
            templateVersion(model.templateVersion);
        }

        public final JourneyPushMessage.Builder getMessageConfig() {
            return messageConfig != null ? messageConfig.toBuilder() : null;
        }

        public final void setMessageConfig(JourneyPushMessage.BuilderImpl messageConfig) {
            this.messageConfig = messageConfig != null ? messageConfig.build() : null;
        }

        @Override
        public final Builder messageConfig(JourneyPushMessage messageConfig) {
            this.messageConfig = messageConfig;
            return this;
        }

        public final String getNextActivity() {
            return nextActivity;
        }

        public final void setNextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
        }

        @Override
        public final Builder nextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateVersion() {
            return templateVersion;
        }

        public final void setTemplateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
        }

        @Override
        public final Builder templateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
            return this;
        }

        @Override
        public PushMessageActivity build() {
            return new PushMessageActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
