/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration and other settings for a message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageRequest implements SdkPojo, Serializable, ToCopyableBuilder<MessageRequest.Builder, MessageRequest> {
    private static final SdkField<Map<String, AddressConfiguration>> ADDRESSES_FIELD = SdkField
            .<Map<String, AddressConfiguration>> builder(MarshallingType.MAP)
            .memberName("Addresses")
            .getter(getter(MessageRequest::addresses))
            .setter(setter(Builder::addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Addresses").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AddressConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddressConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Context")
            .getter(getter(MessageRequest::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, EndpointSendConfiguration>> ENDPOINTS_FIELD = SdkField
            .<Map<String, EndpointSendConfiguration>> builder(MarshallingType.MAP)
            .memberName("Endpoints")
            .getter(getter(MessageRequest::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<EndpointSendConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointSendConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<DirectMessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField
            .<DirectMessageConfiguration> builder(MarshallingType.SDK_POJO).memberName("MessageConfiguration")
            .getter(getter(MessageRequest::messageConfiguration)).setter(setter(Builder::messageConfiguration))
            .constructor(DirectMessageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build())
            .build();

    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField
            .<TemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("TemplateConfiguration")
            .getter(getter(MessageRequest::templateConfiguration)).setter(setter(Builder::templateConfiguration))
            .constructor(TemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build())
            .build();

    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TraceId").getter(getter(MessageRequest::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESSES_FIELD,
            CONTEXT_FIELD, ENDPOINTS_FIELD, MESSAGE_CONFIGURATION_FIELD, TEMPLATE_CONFIGURATION_FIELD, TRACE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, AddressConfiguration> addresses;

    private final Map<String, String> context;

    private final Map<String, EndpointSendConfiguration> endpoints;

    private final DirectMessageConfiguration messageConfiguration;

    private final TemplateConfiguration templateConfiguration;

    private final String traceId;

    private MessageRequest(BuilderImpl builder) {
        this.addresses = builder.addresses;
        this.context = builder.context;
        this.endpoints = builder.endpoints;
        this.messageConfiguration = builder.messageConfiguration;
        this.templateConfiguration = builder.templateConfiguration;
        this.traceId = builder.traceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Addresses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddresses() {
        return addresses != null && !(addresses instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs, where each key is an address and each value is an <a href=
     * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-addressconfiguration"
     * >AddressConfiguration</a> object. An address can be a push notification token, a phone number, or an email
     * address. You can use an <a href=
     * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-addressconfiguration"
     * >AddressConfiguration</a> object to tailor the message for an address by specifying settings such as content
     * overrides and message variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddresses} method.
     * </p>
     * 
     * @return A map of key-value pairs, where each key is an address and each value is an <a href=
     *         "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-addressconfiguration"
     *         >AddressConfiguration</a> object. An address can be a push notification token, a phone number, or an
     *         email address. You can use an <a href=
     *         "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-addressconfiguration"
     *         >AddressConfiguration</a> object to tailor the message for an address by specifying settings such as
     *         content overrides and message variables.
     */
    public final Map<String, AddressConfiguration> addresses() {
        return addresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the Context property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContext() {
        return context != null && !(context instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of custom attributes to attach to the message. For a push notification, this payload is added to the
     * data.pinpoint object. For an email or text message, this payload is added to email/SMS delivery receipt event
     * attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContext} method.
     * </p>
     * 
     * @return A map of custom attributes to attach to the message. For a push notification, this payload is added to
     *         the data.pinpoint object. For an email or text message, this payload is added to email/SMS delivery
     *         receipt event attributes.
     */
    public final Map<String, String> context() {
        return context;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs, where each key is an endpoint ID and each value is an <a href=
     * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration"
     * >EndpointSendConfiguration</a> object. You can use an <a href=
     * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration"
     * >EndpointSendConfiguration</a> object to tailor the message for an endpoint by specifying settings such as
     * content overrides and message variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return A map of key-value pairs, where each key is an endpoint ID and each value is an <a href=
     *         "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration"
     *         >EndpointSendConfiguration</a> object. You can use an <a href=
     *         "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration"
     *         >EndpointSendConfiguration</a> object to tailor the message for an endpoint by specifying settings such
     *         as content overrides and message variables.
     */
    public final Map<String, EndpointSendConfiguration> endpoints() {
        return endpoints;
    }

    /**
     * <p>
     * The settings and content for the default message and any default messages that you defined for specific channels.
     * </p>
     * 
     * @return The settings and content for the default message and any default messages that you defined for specific
     *         channels.
     */
    public final DirectMessageConfiguration messageConfiguration() {
        return messageConfiguration;
    }

    /**
     * <p>
     * The message template to use for the message.
     * </p>
     * 
     * @return The message template to use for the message.
     */
    public final TemplateConfiguration templateConfiguration() {
        return templateConfiguration;
    }

    /**
     * <p>
     * The unique identifier for tracing the message. This identifier is visible to message recipients.
     * </p>
     * 
     * @return The unique identifier for tracing the message. This identifier is visible to message recipients.
     */
    public final String traceId() {
        return traceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAddresses() ? addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContext() ? context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageRequest)) {
            return false;
        }
        MessageRequest other = (MessageRequest) obj;
        return hasAddresses() == other.hasAddresses() && Objects.equals(addresses(), other.addresses())
                && hasContext() == other.hasContext() && Objects.equals(context(), other.context())
                && hasEndpoints() == other.hasEndpoints() && Objects.equals(endpoints(), other.endpoints())
                && Objects.equals(messageConfiguration(), other.messageConfiguration())
                && Objects.equals(templateConfiguration(), other.templateConfiguration())
                && Objects.equals(traceId(), other.traceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageRequest").add("Addresses", hasAddresses() ? addresses() : null)
                .add("Context", hasContext() ? context() : null).add("Endpoints", hasEndpoints() ? endpoints() : null)
                .add("MessageConfiguration", messageConfiguration()).add("TemplateConfiguration", templateConfiguration())
                .add("TraceId", traceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Addresses":
            return Optional.ofNullable(clazz.cast(addresses()));
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "MessageConfiguration":
            return Optional.ofNullable(clazz.cast(messageConfiguration()));
        case "TemplateConfiguration":
            return Optional.ofNullable(clazz.cast(templateConfiguration()));
        case "TraceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Addresses", ADDRESSES_FIELD);
        map.put("Context", CONTEXT_FIELD);
        map.put("Endpoints", ENDPOINTS_FIELD);
        map.put("MessageConfiguration", MESSAGE_CONFIGURATION_FIELD);
        map.put("TemplateConfiguration", TEMPLATE_CONFIGURATION_FIELD);
        map.put("TraceId", TRACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageRequest, T> g) {
        return obj -> g.apply((MessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageRequest> {
        /**
         * <p>
         * A map of key-value pairs, where each key is an address and each value is an <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-addressconfiguration"
         * >AddressConfiguration</a> object. An address can be a push notification token, a phone number, or an email
         * address. You can use an <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-addressconfiguration"
         * >AddressConfiguration</a> object to tailor the message for an address by specifying settings such as content
         * overrides and message variables.
         * </p>
         * 
         * @param addresses
         *        A map of key-value pairs, where each key is an address and each value is an <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-addressconfiguration"
         *        >AddressConfiguration</a> object. An address can be a push notification token, a phone number, or an
         *        email address. You can use an <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-addressconfiguration"
         *        >AddressConfiguration</a> object to tailor the message for an address by specifying settings such as
         *        content overrides and message variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Map<String, AddressConfiguration> addresses);

        /**
         * <p>
         * A map of custom attributes to attach to the message. For a push notification, this payload is added to the
         * data.pinpoint object. For an email or text message, this payload is added to email/SMS delivery receipt event
         * attributes.
         * </p>
         * 
         * @param context
         *        A map of custom attributes to attach to the message. For a push notification, this payload is added to
         *        the data.pinpoint object. For an email or text message, this payload is added to email/SMS delivery
         *        receipt event attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(Map<String, String> context);

        /**
         * <p>
         * A map of key-value pairs, where each key is an endpoint ID and each value is an <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration"
         * >EndpointSendConfiguration</a> object. You can use an <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration"
         * >EndpointSendConfiguration</a> object to tailor the message for an endpoint by specifying settings such as
         * content overrides and message variables.
         * </p>
         * 
         * @param endpoints
         *        A map of key-value pairs, where each key is an endpoint ID and each value is an <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration"
         *        >EndpointSendConfiguration</a> object. You can use an <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration"
         *        >EndpointSendConfiguration</a> object to tailor the message for an endpoint by specifying settings
         *        such as content overrides and message variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Map<String, EndpointSendConfiguration> endpoints);

        /**
         * <p>
         * The settings and content for the default message and any default messages that you defined for specific
         * channels.
         * </p>
         * 
         * @param messageConfiguration
         *        The settings and content for the default message and any default messages that you defined for
         *        specific channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageConfiguration(DirectMessageConfiguration messageConfiguration);

        /**
         * <p>
         * The settings and content for the default message and any default messages that you defined for specific
         * channels.
         * </p>
         * This is a convenience method that creates an instance of the {@link DirectMessageConfiguration.Builder}
         * avoiding the need to create one manually via {@link DirectMessageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectMessageConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #messageConfiguration(DirectMessageConfiguration)}.
         * 
         * @param messageConfiguration
         *        a consumer that will call methods on {@link DirectMessageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageConfiguration(DirectMessageConfiguration)
         */
        default Builder messageConfiguration(Consumer<DirectMessageConfiguration.Builder> messageConfiguration) {
            return messageConfiguration(DirectMessageConfiguration.builder().applyMutation(messageConfiguration).build());
        }

        /**
         * <p>
         * The message template to use for the message.
         * </p>
         * 
         * @param templateConfiguration
         *        The message template to use for the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateConfiguration(TemplateConfiguration templateConfiguration);

        /**
         * <p>
         * The message template to use for the message.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateConfiguration.Builder} avoiding
         * the need to create one manually via {@link TemplateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #templateConfiguration(TemplateConfiguration)}.
         * 
         * @param templateConfiguration
         *        a consumer that will call methods on {@link TemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateConfiguration(TemplateConfiguration)
         */
        default Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return templateConfiguration(TemplateConfiguration.builder().applyMutation(templateConfiguration).build());
        }

        /**
         * <p>
         * The unique identifier for tracing the message. This identifier is visible to message recipients.
         * </p>
         * 
         * @param traceId
         *        The unique identifier for tracing the message. This identifier is visible to message recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, AddressConfiguration> addresses = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, EndpointSendConfiguration> endpoints = DefaultSdkAutoConstructMap.getInstance();

        private DirectMessageConfiguration messageConfiguration;

        private TemplateConfiguration templateConfiguration;

        private String traceId;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageRequest model) {
            addresses(model.addresses);
            context(model.context);
            endpoints(model.endpoints);
            messageConfiguration(model.messageConfiguration);
            templateConfiguration(model.templateConfiguration);
            traceId(model.traceId);
        }

        public final Map<String, AddressConfiguration.Builder> getAddresses() {
            Map<String, AddressConfiguration.Builder> result = MapOfAddressConfigurationCopier.copyToBuilder(this.addresses);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAddresses(Map<String, AddressConfiguration.BuilderImpl> addresses) {
            this.addresses = MapOfAddressConfigurationCopier.copyFromBuilder(addresses);
        }

        @Override
        public final Builder addresses(Map<String, AddressConfiguration> addresses) {
            this.addresses = MapOfAddressConfigurationCopier.copy(addresses);
            return this;
        }

        public final Map<String, String> getContext() {
            if (context instanceof SdkAutoConstructMap) {
                return null;
            }
            return context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
            return this;
        }

        public final Map<String, EndpointSendConfiguration.Builder> getEndpoints() {
            Map<String, EndpointSendConfiguration.Builder> result = MapOfEndpointSendConfigurationCopier
                    .copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Map<String, EndpointSendConfiguration.BuilderImpl> endpoints) {
            this.endpoints = MapOfEndpointSendConfigurationCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Map<String, EndpointSendConfiguration> endpoints) {
            this.endpoints = MapOfEndpointSendConfigurationCopier.copy(endpoints);
            return this;
        }

        public final DirectMessageConfiguration.Builder getMessageConfiguration() {
            return messageConfiguration != null ? messageConfiguration.toBuilder() : null;
        }

        public final void setMessageConfiguration(DirectMessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        @Override
        public final Builder messageConfiguration(DirectMessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return templateConfiguration != null ? templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        @Override
        public MessageRequest build() {
            return new MessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
