/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetImportJobResponse extends PinpointResponse implements
        ToCopyableBuilder<GetImportJobResponse.Builder, GetImportJobResponse> {
    private static final SdkField<ImportJobResponse> IMPORT_JOB_RESPONSE_FIELD = SdkField
            .<ImportJobResponse> builder(MarshallingType.SDK_POJO)
            .memberName("ImportJobResponse")
            .getter(getter(GetImportJobResponse::importJobResponse))
            .setter(setter(Builder::importJobResponse))
            .constructor(ImportJobResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_JOB_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ImportJobResponse importJobResponse;

    private GetImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.importJobResponse = builder.importJobResponse;
    }

    /**
     * Returns the value of the ImportJobResponse property for this object.
     * 
     * @return The value of the ImportJobResponse property for this object.
     */
    public final ImportJobResponse importJobResponse() {
        return importJobResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importJobResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImportJobResponse)) {
            return false;
        }
        GetImportJobResponse other = (GetImportJobResponse) obj;
        return Objects.equals(importJobResponse(), other.importJobResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetImportJobResponse").add("ImportJobResponse", importJobResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportJobResponse":
            return Optional.ofNullable(clazz.cast(importJobResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImportJobResponse", IMPORT_JOB_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetImportJobResponse, T> g) {
        return obj -> g.apply((GetImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetImportJobResponse> {
        /**
         * Sets the value of the ImportJobResponse property for this object.
         *
         * @param importJobResponse
         *        The new value for the ImportJobResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobResponse(ImportJobResponse importJobResponse);

        /**
         * Sets the value of the ImportJobResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ImportJobResponse.Builder} avoiding the
         * need to create one manually via {@link ImportJobResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportJobResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #importJobResponse(ImportJobResponse)}.
         * 
         * @param importJobResponse
         *        a consumer that will call methods on {@link ImportJobResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importJobResponse(ImportJobResponse)
         */
        default Builder importJobResponse(Consumer<ImportJobResponse.Builder> importJobResponse) {
            return importJobResponse(ImportJobResponse.builder().applyMutation(importJobResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private ImportJobResponse importJobResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImportJobResponse model) {
            super(model);
            importJobResponse(model.importJobResponse);
        }

        public final ImportJobResponse.Builder getImportJobResponse() {
            return importJobResponse != null ? importJobResponse.toBuilder() : null;
        }

        public final void setImportJobResponse(ImportJobResponse.BuilderImpl importJobResponse) {
            this.importJobResponse = importJobResponse != null ? importJobResponse.build() : null;
        }

        @Override
        public final Builder importJobResponse(ImportJobResponse importJobResponse) {
            this.importJobResponse = importJobResponse;
            return this;
        }

        @Override
        public GetImportJobResponse build() {
            return new GetImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
