/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationDateRangeKpiResponse extends PinpointResponse implements
        ToCopyableBuilder<GetApplicationDateRangeKpiResponse.Builder, GetApplicationDateRangeKpiResponse> {
    private static final SdkField<ApplicationDateRangeKpiResponse> APPLICATION_DATE_RANGE_KPI_RESPONSE_FIELD = SdkField
            .<ApplicationDateRangeKpiResponse> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationDateRangeKpiResponse")
            .getter(getter(GetApplicationDateRangeKpiResponse::applicationDateRangeKpiResponse))
            .setter(setter(Builder::applicationDateRangeKpiResponse))
            .constructor(ApplicationDateRangeKpiResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDateRangeKpiResponse")
                    .build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPLICATION_DATE_RANGE_KPI_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ApplicationDateRangeKpiResponse applicationDateRangeKpiResponse;

    private GetApplicationDateRangeKpiResponse(BuilderImpl builder) {
        super(builder);
        this.applicationDateRangeKpiResponse = builder.applicationDateRangeKpiResponse;
    }

    /**
     * Returns the value of the ApplicationDateRangeKpiResponse property for this object.
     * 
     * @return The value of the ApplicationDateRangeKpiResponse property for this object.
     */
    public final ApplicationDateRangeKpiResponse applicationDateRangeKpiResponse() {
        return applicationDateRangeKpiResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationDateRangeKpiResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationDateRangeKpiResponse)) {
            return false;
        }
        GetApplicationDateRangeKpiResponse other = (GetApplicationDateRangeKpiResponse) obj;
        return Objects.equals(applicationDateRangeKpiResponse(), other.applicationDateRangeKpiResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationDateRangeKpiResponse")
                .add("ApplicationDateRangeKpiResponse", applicationDateRangeKpiResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationDateRangeKpiResponse":
            return Optional.ofNullable(clazz.cast(applicationDateRangeKpiResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationDateRangeKpiResponse", APPLICATION_DATE_RANGE_KPI_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationDateRangeKpiResponse, T> g) {
        return obj -> g.apply((GetApplicationDateRangeKpiResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApplicationDateRangeKpiResponse> {
        /**
         * Sets the value of the ApplicationDateRangeKpiResponse property for this object.
         *
         * @param applicationDateRangeKpiResponse
         *        The new value for the ApplicationDateRangeKpiResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDateRangeKpiResponse(ApplicationDateRangeKpiResponse applicationDateRangeKpiResponse);

        /**
         * Sets the value of the ApplicationDateRangeKpiResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ApplicationDateRangeKpiResponse.Builder}
         * avoiding the need to create one manually via {@link ApplicationDateRangeKpiResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationDateRangeKpiResponse.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #applicationDateRangeKpiResponse(ApplicationDateRangeKpiResponse)}.
         * 
         * @param applicationDateRangeKpiResponse
         *        a consumer that will call methods on {@link ApplicationDateRangeKpiResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationDateRangeKpiResponse(ApplicationDateRangeKpiResponse)
         */
        default Builder applicationDateRangeKpiResponse(
                Consumer<ApplicationDateRangeKpiResponse.Builder> applicationDateRangeKpiResponse) {
            return applicationDateRangeKpiResponse(ApplicationDateRangeKpiResponse.builder()
                    .applyMutation(applicationDateRangeKpiResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private ApplicationDateRangeKpiResponse applicationDateRangeKpiResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationDateRangeKpiResponse model) {
            super(model);
            applicationDateRangeKpiResponse(model.applicationDateRangeKpiResponse);
        }

        public final ApplicationDateRangeKpiResponse.Builder getApplicationDateRangeKpiResponse() {
            return applicationDateRangeKpiResponse != null ? applicationDateRangeKpiResponse.toBuilder() : null;
        }

        public final void setApplicationDateRangeKpiResponse(
                ApplicationDateRangeKpiResponse.BuilderImpl applicationDateRangeKpiResponse) {
            this.applicationDateRangeKpiResponse = applicationDateRangeKpiResponse != null ? applicationDateRangeKpiResponse
                    .build() : null;
        }

        @Override
        public final Builder applicationDateRangeKpiResponse(ApplicationDateRangeKpiResponse applicationDateRangeKpiResponse) {
            this.applicationDateRangeKpiResponse = applicationDateRangeKpiResponse;
            return this;
        }

        @Override
        public GetApplicationDateRangeKpiResponse build() {
            return new GetApplicationDateRangeKpiResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
