/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the resource settings for a job that exports endpoint definitions to a file. The file can
 * be added directly to an Amazon Simple Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API or
 * downloaded directly to a computer by using the Amazon Pinpoint console.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportJobResource implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportJobResource.Builder, ExportJobResource> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(ExportJobResource::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> S3_URL_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3UrlPrefix").getter(getter(ExportJobResource::s3UrlPrefix)).setter(setter(Builder::s3UrlPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3UrlPrefix").build()).build();

    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentId").getter(getter(ExportJobResource::segmentId)).setter(setter(Builder::segmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()).build();

    private static final SdkField<Integer> SEGMENT_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentVersion").getter(getter(ExportJobResource::segmentVersion))
            .setter(setter(Builder::segmentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            S3_URL_PREFIX_FIELD, SEGMENT_ID_FIELD, SEGMENT_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String s3UrlPrefix;

    private final String segmentId;

    private final Integer segmentVersion;

    private ExportJobResource(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.s3UrlPrefix = builder.s3UrlPrefix;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorized Amazon
     * Pinpoint to access the Amazon S3 location where the endpoint definitions were exported to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorized
     *         Amazon Pinpoint to access the Amazon S3 location where the endpoint definitions were exported to.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket where the endpoint definitions
     * were exported to. This location is typically a folder that contains multiple files. The URL should be in the
     * following format: s3://<replaceable>bucket-name</replaceable>/<replaceable>folder-name</replaceable>/.
     * </p>
     * 
     * @return The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket where the endpoint
     *         definitions were exported to. This location is typically a folder that contains multiple files. The URL
     *         should be in the following format:
     *         s3://<replaceable>bucket-name</replaceable>/<replaceable>folder-name</replaceable>/.
     */
    public final String s3UrlPrefix() {
        return s3UrlPrefix;
    }

    /**
     * <p>
     * The identifier for the segment that the endpoint definitions were exported from. If this value isn't present,
     * Amazon Pinpoint exported definitions for all the endpoints that are associated with the application.
     * </p>
     * 
     * @return The identifier for the segment that the endpoint definitions were exported from. If this value isn't
     *         present, Amazon Pinpoint exported definitions for all the endpoints that are associated with the
     *         application.
     */
    public final String segmentId() {
        return segmentId;
    }

    /**
     * <p>
     * The version of the segment that the endpoint definitions were exported from.
     * </p>
     * 
     * @return The version of the segment that the endpoint definitions were exported from.
     */
    public final Integer segmentVersion() {
        return segmentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3UrlPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportJobResource)) {
            return false;
        }
        ExportJobResource other = (ExportJobResource) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(s3UrlPrefix(), other.s3UrlPrefix())
                && Objects.equals(segmentId(), other.segmentId()) && Objects.equals(segmentVersion(), other.segmentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportJobResource").add("RoleArn", roleArn()).add("S3UrlPrefix", s3UrlPrefix())
                .add("SegmentId", segmentId()).add("SegmentVersion", segmentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "S3UrlPrefix":
            return Optional.ofNullable(clazz.cast(s3UrlPrefix()));
        case "SegmentId":
            return Optional.ofNullable(clazz.cast(segmentId()));
        case "SegmentVersion":
            return Optional.ofNullable(clazz.cast(segmentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("S3UrlPrefix", S3_URL_PREFIX_FIELD);
        map.put("SegmentId", SEGMENT_ID_FIELD);
        map.put("SegmentVersion", SEGMENT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportJobResource, T> g) {
        return obj -> g.apply((ExportJobResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportJobResource> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorized Amazon
         * Pinpoint to access the Amazon S3 location where the endpoint definitions were exported to.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorized
         *        Amazon Pinpoint to access the Amazon S3 location where the endpoint definitions were exported to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket where the endpoint definitions
         * were exported to. This location is typically a folder that contains multiple files. The URL should be in the
         * following format: s3://<replaceable>bucket-name</replaceable>/<replaceable>folder-name</replaceable>/.
         * </p>
         * 
         * @param s3UrlPrefix
         *        The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket where the endpoint
         *        definitions were exported to. This location is typically a folder that contains multiple files. The
         *        URL should be in the following format:
         *        s3://<replaceable>bucket-name</replaceable>/<replaceable>folder-name</replaceable>/.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3UrlPrefix(String s3UrlPrefix);

        /**
         * <p>
         * The identifier for the segment that the endpoint definitions were exported from. If this value isn't present,
         * Amazon Pinpoint exported definitions for all the endpoints that are associated with the application.
         * </p>
         * 
         * @param segmentId
         *        The identifier for the segment that the endpoint definitions were exported from. If this value isn't
         *        present, Amazon Pinpoint exported definitions for all the endpoints that are associated with the
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentId(String segmentId);

        /**
         * <p>
         * The version of the segment that the endpoint definitions were exported from.
         * </p>
         * 
         * @param segmentVersion
         *        The version of the segment that the endpoint definitions were exported from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentVersion(Integer segmentVersion);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String s3UrlPrefix;

        private String segmentId;

        private Integer segmentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportJobResource model) {
            roleArn(model.roleArn);
            s3UrlPrefix(model.s3UrlPrefix);
            segmentId(model.segmentId);
            segmentVersion(model.segmentVersion);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getS3UrlPrefix() {
            return s3UrlPrefix;
        }

        public final void setS3UrlPrefix(String s3UrlPrefix) {
            this.s3UrlPrefix = s3UrlPrefix;
        }

        @Override
        public final Builder s3UrlPrefix(String s3UrlPrefix) {
            this.s3UrlPrefix = s3UrlPrefix;
            return this;
        }

        public final String getSegmentId() {
            return segmentId;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final Integer getSegmentVersion() {
            return segmentVersion;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        @Override
        public ExportJobResource build() {
            return new ExportJobResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
