/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the content and settings for a message template that can be used in messages that are sent through the
 * email channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailTemplateRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailTemplateRequest.Builder, EmailTemplateRequest> {
    private static final SdkField<String> DEFAULT_SUBSTITUTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultSubstitutions").getter(getter(EmailTemplateRequest::defaultSubstitutions))
            .setter(setter(Builder::defaultSubstitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubstitutions").build())
            .build();

    private static final SdkField<String> HTML_PART_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HtmlPart").getter(getter(EmailTemplateRequest::htmlPart)).setter(setter(Builder::htmlPart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HtmlPart").build()).build();

    private static final SdkField<String> RECOMMENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommenderId").getter(getter(EmailTemplateRequest::recommenderId))
            .setter(setter(Builder::recommenderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderId").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(EmailTemplateRequest::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<List<MessageHeader>> HEADERS_FIELD = SdkField
            .<List<MessageHeader>> builder(MarshallingType.LIST)
            .memberName("Headers")
            .getter(getter(EmailTemplateRequest::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(EmailTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateDescription").getter(getter(EmailTemplateRequest::templateDescription))
            .setter(setter(Builder::templateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build())
            .build();

    private static final SdkField<String> TEXT_PART_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextPart").getter(getter(EmailTemplateRequest::textPart)).setter(setter(Builder::textPart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextPart").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_SUBSTITUTIONS_FIELD,
            HTML_PART_FIELD, RECOMMENDER_ID_FIELD, SUBJECT_FIELD, HEADERS_FIELD, TAGS_FIELD, TEMPLATE_DESCRIPTION_FIELD,
            TEXT_PART_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String defaultSubstitutions;

    private final String htmlPart;

    private final String recommenderId;

    private final String subject;

    private final List<MessageHeader> headers;

    private final Map<String, String> tags;

    private final String templateDescription;

    private final String textPart;

    private EmailTemplateRequest(BuilderImpl builder) {
        this.defaultSubstitutions = builder.defaultSubstitutions;
        this.htmlPart = builder.htmlPart;
        this.recommenderId = builder.recommenderId;
        this.subject = builder.subject;
        this.headers = builder.headers;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
        this.textPart = builder.textPart;
    }

    /**
     * <p>
     * A JSON object that specifies the default values to use for message variables in the message template. This object
     * is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines
     * the default value for that variable. When you create a message that's based on the template, you can override
     * these defaults with message-specific and address-specific variables and values.
     * </p>
     * 
     * @return A JSON object that specifies the default values to use for message variables in the message template.
     *         This object is a set of key-value pairs. Each key defines a message variable in the template. The
     *         corresponding value defines the default value for that variable. When you create a message that's based
     *         on the template, you can override these defaults with message-specific and address-specific variables and
     *         values.
     */
    public final String defaultSubstitutions() {
        return defaultSubstitutions;
    }

    /**
     * <p>
     * The message body, in HTML format, to use in email messages that are based on the message template. We recommend
     * using HTML format for email clients that render HTML content. You can include links, formatted text, and more in
     * an HTML message.
     * </p>
     * 
     * @return The message body, in HTML format, to use in email messages that are based on the message template. We
     *         recommend using HTML format for email clients that render HTML content. You can include links, formatted
     *         text, and more in an HTML message.
     */
    public final String htmlPart() {
        return htmlPart;
    }

    /**
     * <p>
     * The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value
     * to determine how to retrieve and process data from a recommender model when it sends messages that use the
     * template, if the template contains message variables for recommendation data.
     * </p>
     * 
     * @return The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses
     *         this value to determine how to retrieve and process data from a recommender model when it sends messages
     *         that use the template, if the template contains message variables for recommendation data.
     */
    public final String recommenderId() {
        return recommenderId;
    }

    /**
     * <p>
     * The subject line, or title, to use in email messages that are based on the message template.
     * </p>
     * 
     * @return The subject line, or title, to use in email messages that are based on the message template.
     */
    public final String subject() {
        return subject;
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <a href=
     * "https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader"
     * >MessageHeaders</a> for the email. You can have up to 15 Headers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return The list of <a href=
     *         "https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader"
     *         >MessageHeaders</a> for the email. You can have up to 15 Headers.
     */
    public final List<MessageHeader> headers() {
        return headers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <note>
     * <p>
     * As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags is not
     * processed and an error code is not returned. To manage tags we recommend using either <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the <i>API
     * Reference for Amazon Pinpoint</i>, <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html"
     * >resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href=
     * "https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html"
     * >resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.
     * </p>
     * </note>
     * <p>
     * (Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message
     * template. Each tag consists of a required tag key and an associated tag value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags
     *         is not processed and an error code is not returned. To manage tags we recommend using either <a
     *         href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the
     *         <i>API Reference for Amazon Pinpoint</i>, <a
     *         href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html"
     *         >resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href=
     *         "https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html"
     *         >resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.</p></note>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A custom description of the message template.
     * </p>
     * 
     * @return A custom description of the message template.
     */
    public final String templateDescription() {
        return templateDescription;
    }

    /**
     * <p>
     * The message body, in plain text format, to use in email messages that are based on the message template. We
     * recommend using plain text format for email clients that don't render HTML content and clients that are connected
     * to high-latency networks, such as mobile devices.
     * </p>
     * 
     * @return The message body, in plain text format, to use in email messages that are based on the message template.
     *         We recommend using plain text format for email clients that don't render HTML content and clients that
     *         are connected to high-latency networks, such as mobile devices.
     */
    public final String textPart() {
        return textPart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultSubstitutions());
        hashCode = 31 * hashCode + Objects.hashCode(htmlPart());
        hashCode = 31 * hashCode + Objects.hashCode(recommenderId());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(textPart());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailTemplateRequest)) {
            return false;
        }
        EmailTemplateRequest other = (EmailTemplateRequest) obj;
        return Objects.equals(defaultSubstitutions(), other.defaultSubstitutions())
                && Objects.equals(htmlPart(), other.htmlPart()) && Objects.equals(recommenderId(), other.recommenderId())
                && Objects.equals(subject(), other.subject()) && hasHeaders() == other.hasHeaders()
                && Objects.equals(headers(), other.headers()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(templateDescription(), other.templateDescription())
                && Objects.equals(textPart(), other.textPart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailTemplateRequest").add("DefaultSubstitutions", defaultSubstitutions())
                .add("HtmlPart", htmlPart()).add("RecommenderId", recommenderId()).add("Subject", subject())
                .add("Headers", hasHeaders() ? headers() : null).add("Tags", hasTags() ? tags() : null)
                .add("TemplateDescription", templateDescription()).add("TextPart", textPart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultSubstitutions":
            return Optional.ofNullable(clazz.cast(defaultSubstitutions()));
        case "HtmlPart":
            return Optional.ofNullable(clazz.cast(htmlPart()));
        case "RecommenderId":
            return Optional.ofNullable(clazz.cast(recommenderId()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "Headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TemplateDescription":
            return Optional.ofNullable(clazz.cast(templateDescription()));
        case "TextPart":
            return Optional.ofNullable(clazz.cast(textPart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultSubstitutions", DEFAULT_SUBSTITUTIONS_FIELD);
        map.put("HtmlPart", HTML_PART_FIELD);
        map.put("RecommenderId", RECOMMENDER_ID_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        map.put("Headers", HEADERS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("TemplateDescription", TEMPLATE_DESCRIPTION_FIELD);
        map.put("TextPart", TEXT_PART_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailTemplateRequest, T> g) {
        return obj -> g.apply((EmailTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailTemplateRequest> {
        /**
         * <p>
         * A JSON object that specifies the default values to use for message variables in the message template. This
         * object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding
         * value defines the default value for that variable. When you create a message that's based on the template,
         * you can override these defaults with message-specific and address-specific variables and values.
         * </p>
         * 
         * @param defaultSubstitutions
         *        A JSON object that specifies the default values to use for message variables in the message template.
         *        This object is a set of key-value pairs. Each key defines a message variable in the template. The
         *        corresponding value defines the default value for that variable. When you create a message that's
         *        based on the template, you can override these defaults with message-specific and address-specific
         *        variables and values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSubstitutions(String defaultSubstitutions);

        /**
         * <p>
         * The message body, in HTML format, to use in email messages that are based on the message template. We
         * recommend using HTML format for email clients that render HTML content. You can include links, formatted
         * text, and more in an HTML message.
         * </p>
         * 
         * @param htmlPart
         *        The message body, in HTML format, to use in email messages that are based on the message template. We
         *        recommend using HTML format for email clients that render HTML content. You can include links,
         *        formatted text, and more in an HTML message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder htmlPart(String htmlPart);

        /**
         * <p>
         * The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this
         * value to determine how to retrieve and process data from a recommender model when it sends messages that use
         * the template, if the template contains message variables for recommendation data.
         * </p>
         * 
         * @param recommenderId
         *        The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses
         *        this value to determine how to retrieve and process data from a recommender model when it sends
         *        messages that use the template, if the template contains message variables for recommendation data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommenderId(String recommenderId);

        /**
         * <p>
         * The subject line, or title, to use in email messages that are based on the message template.
         * </p>
         * 
         * @param subject
         *        The subject line, or title, to use in email messages that are based on the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The list of <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader"
         * >MessageHeaders</a> for the email. You can have up to 15 Headers.
         * </p>
         * 
         * @param headers
         *        The list of <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader"
         *        >MessageHeaders</a> for the email. You can have up to 15 Headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Collection<MessageHeader> headers);

        /**
         * <p>
         * The list of <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader"
         * >MessageHeaders</a> for the email. You can have up to 15 Headers.
         * </p>
         * 
         * @param headers
         *        The list of <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader"
         *        >MessageHeaders</a> for the email. You can have up to 15 Headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(MessageHeader... headers);

        /**
         * <p>
         * The list of <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader"
         * >MessageHeaders</a> for the email. You can have up to 15 Headers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader.Builder#build()} is called immediately
         * and its result is passed to {@link #headers(List<MessageHeader>)}.
         * 
         * @param headers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(java.util.Collection<MessageHeader>)
         */
        Builder headers(Consumer<MessageHeader.Builder>... headers);

        /**
         * <note>
         * <p>
         * As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags is
         * not processed and an error code is not returned. To manage tags we recommend using either <a
         * href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the <i>API
         * Reference for Amazon Pinpoint</i>, <a
         * href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html"
         * >resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href=
         * "https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html"
         * >resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.
         * </p>
         * </note>
         * <p>
         * (Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message
         * template. Each tag consists of a required tag key and an associated tag value.
         * </p>
         * 
         * @param tags
         *        As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in
         *        tags is not processed and an error code is not returned. To manage tags we recommend using either <a
         *        href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the
         *        <i>API Reference for Amazon Pinpoint</i>, <a
         *        href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html"
         *        >resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a
         *        href=
         *        "https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html"
         *        >resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.</p></note>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A custom description of the message template.
         * </p>
         * 
         * @param templateDescription
         *        A custom description of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateDescription(String templateDescription);

        /**
         * <p>
         * The message body, in plain text format, to use in email messages that are based on the message template. We
         * recommend using plain text format for email clients that don't render HTML content and clients that are
         * connected to high-latency networks, such as mobile devices.
         * </p>
         * 
         * @param textPart
         *        The message body, in plain text format, to use in email messages that are based on the message
         *        template. We recommend using plain text format for email clients that don't render HTML content and
         *        clients that are connected to high-latency networks, such as mobile devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textPart(String textPart);
    }

    static final class BuilderImpl implements Builder {
        private String defaultSubstitutions;

        private String htmlPart;

        private String recommenderId;

        private String subject;

        private List<MessageHeader> headers = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String templateDescription;

        private String textPart;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailTemplateRequest model) {
            defaultSubstitutions(model.defaultSubstitutions);
            htmlPart(model.htmlPart);
            recommenderId(model.recommenderId);
            subject(model.subject);
            headers(model.headers);
            tags(model.tags);
            templateDescription(model.templateDescription);
            textPart(model.textPart);
        }

        public final String getDefaultSubstitutions() {
            return defaultSubstitutions;
        }

        public final void setDefaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
        }

        @Override
        public final Builder defaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        public final String getHtmlPart() {
            return htmlPart;
        }

        public final void setHtmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
        }

        @Override
        public final Builder htmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
            return this;
        }

        public final String getRecommenderId() {
            return recommenderId;
        }

        public final void setRecommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
        }

        @Override
        public final Builder recommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final List<MessageHeader.Builder> getHeaders() {
            List<MessageHeader.Builder> result = ListOfMessageHeaderCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<MessageHeader.BuilderImpl> headers) {
            this.headers = ListOfMessageHeaderCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<MessageHeader> headers) {
            this.headers = ListOfMessageHeaderCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(MessageHeader... headers) {
            headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<MessageHeader.Builder>... headers) {
            headers(Stream.of(headers).map(c -> MessageHeader.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTemplateDescription() {
            return templateDescription;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final String getTextPart() {
            return textPart;
        }

        public final void setTextPart(String textPart) {
            this.textPart = textPart;
        }

        @Override
        public final Builder textPart(String textPart) {
            this.textPart = textPart;
            return this;
        }

        @Override
        public EmailTemplateRequest build() {
            return new EmailTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
