/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement;
import software.amazon.awssdk.services.pinpoint.model.JourneyCustomMessage;
import software.amazon.awssdk.services.pinpoint.model.ListOf__EndpointTypesElementCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomMessageActivity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomMessageActivity> {
    private static final SdkField<String> DELIVERY_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryUri").getter(CustomMessageActivity.getter(CustomMessageActivity::deliveryUri)).setter(CustomMessageActivity.setter(Builder::deliveryUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryUri").build()}).build();
    private static final SdkField<List<String>> ENDPOINT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointTypes").getter(CustomMessageActivity.getter(CustomMessageActivity::endpointTypesAsStrings)).setter(CustomMessageActivity.setter(Builder::endpointTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<JourneyCustomMessage> MESSAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MessageConfig").getter(CustomMessageActivity.getter(CustomMessageActivity::messageConfig)).setter(CustomMessageActivity.setter(Builder::messageConfig)).constructor(JourneyCustomMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfig").build()}).build();
    private static final SdkField<String> NEXT_ACTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextActivity").getter(CustomMessageActivity.getter(CustomMessageActivity::nextActivity)).setter(CustomMessageActivity.setter(Builder::nextActivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextActivity").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(CustomMessageActivity.getter(CustomMessageActivity::templateName)).setter(CustomMessageActivity.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> TEMPLATE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateVersion").getter(CustomMessageActivity.getter(CustomMessageActivity::templateVersion)).setter(CustomMessageActivity.setter(Builder::templateVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_URI_FIELD, ENDPOINT_TYPES_FIELD, MESSAGE_CONFIG_FIELD, NEXT_ACTIVITY_FIELD, TEMPLATE_NAME_FIELD, TEMPLATE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomMessageActivity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String deliveryUri;
    private final List<String> endpointTypes;
    private final JourneyCustomMessage messageConfig;
    private final String nextActivity;
    private final String templateName;
    private final String templateVersion;

    private CustomMessageActivity(BuilderImpl builder) {
        this.deliveryUri = builder.deliveryUri;
        this.endpointTypes = builder.endpointTypes;
        this.messageConfig = builder.messageConfig;
        this.nextActivity = builder.nextActivity;
        this.templateName = builder.templateName;
        this.templateVersion = builder.templateVersion;
    }

    public final String deliveryUri() {
        return this.deliveryUri;
    }

    public final List<EndpointTypesElement> endpointTypes() {
        return ListOf__EndpointTypesElementCopier.copyStringToEnum(this.endpointTypes);
    }

    public final boolean hasEndpointTypes() {
        return this.endpointTypes != null && !(this.endpointTypes instanceof SdkAutoConstructList);
    }

    public final List<String> endpointTypesAsStrings() {
        return this.endpointTypes;
    }

    public final JourneyCustomMessage messageConfig() {
        return this.messageConfig;
    }

    public final String nextActivity() {
        return this.nextActivity;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String templateVersion() {
        return this.templateVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointTypes() ? this.endpointTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.messageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextActivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomMessageActivity)) {
            return false;
        }
        CustomMessageActivity other = (CustomMessageActivity)obj;
        return Objects.equals(this.deliveryUri(), other.deliveryUri()) && this.hasEndpointTypes() == other.hasEndpointTypes() && Objects.equals(this.endpointTypesAsStrings(), other.endpointTypesAsStrings()) && Objects.equals(this.messageConfig(), other.messageConfig()) && Objects.equals(this.nextActivity(), other.nextActivity()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateVersion(), other.templateVersion());
    }

    public final String toString() {
        return ToString.builder((String)"CustomMessageActivity").add("DeliveryUri", (Object)this.deliveryUri()).add("EndpointTypes", this.hasEndpointTypes() ? this.endpointTypesAsStrings() : null).add("MessageConfig", (Object)this.messageConfig()).add("NextActivity", (Object)this.nextActivity()).add("TemplateName", (Object)this.templateName()).add("TemplateVersion", (Object)this.templateVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryUri": {
                return Optional.ofNullable(clazz.cast(this.deliveryUri()));
            }
            case "EndpointTypes": {
                return Optional.ofNullable(clazz.cast(this.endpointTypesAsStrings()));
            }
            case "MessageConfig": {
                return Optional.ofNullable(clazz.cast(this.messageConfig()));
            }
            case "NextActivity": {
                return Optional.ofNullable(clazz.cast(this.nextActivity()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "TemplateVersion": {
                return Optional.ofNullable(clazz.cast(this.templateVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeliveryUri", DELIVERY_URI_FIELD);
        map.put("EndpointTypes", ENDPOINT_TYPES_FIELD);
        map.put("MessageConfig", MESSAGE_CONFIG_FIELD);
        map.put("NextActivity", NEXT_ACTIVITY_FIELD);
        map.put("TemplateName", TEMPLATE_NAME_FIELD);
        map.put("TemplateVersion", TEMPLATE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomMessageActivity, T> g) {
        return obj -> g.apply((CustomMessageActivity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryUri;
        private List<String> endpointTypes = DefaultSdkAutoConstructList.getInstance();
        private JourneyCustomMessage messageConfig;
        private String nextActivity;
        private String templateName;
        private String templateVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomMessageActivity model) {
            this.deliveryUri(model.deliveryUri);
            this.endpointTypesWithStrings(model.endpointTypes);
            this.messageConfig(model.messageConfig);
            this.nextActivity(model.nextActivity);
            this.templateName(model.templateName);
            this.templateVersion(model.templateVersion);
        }

        public final String getDeliveryUri() {
            return this.deliveryUri;
        }

        public final void setDeliveryUri(String deliveryUri) {
            this.deliveryUri = deliveryUri;
        }

        @Override
        public final Builder deliveryUri(String deliveryUri) {
            this.deliveryUri = deliveryUri;
            return this;
        }

        public final Collection<String> getEndpointTypes() {
            if (this.endpointTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpointTypes;
        }

        public final void setEndpointTypes(Collection<String> endpointTypes) {
            this.endpointTypes = ListOf__EndpointTypesElementCopier.copy(endpointTypes);
        }

        @Override
        public final Builder endpointTypesWithStrings(Collection<String> endpointTypes) {
            this.endpointTypes = ListOf__EndpointTypesElementCopier.copy(endpointTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointTypesWithStrings(String ... endpointTypes) {
            this.endpointTypesWithStrings(Arrays.asList(endpointTypes));
            return this;
        }

        @Override
        public final Builder endpointTypes(Collection<EndpointTypesElement> endpointTypes) {
            this.endpointTypes = ListOf__EndpointTypesElementCopier.copyEnumToString(endpointTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointTypes(EndpointTypesElement ... endpointTypes) {
            this.endpointTypes(Arrays.asList(endpointTypes));
            return this;
        }

        public final JourneyCustomMessage.Builder getMessageConfig() {
            return this.messageConfig != null ? this.messageConfig.toBuilder() : null;
        }

        public final void setMessageConfig(JourneyCustomMessage.BuilderImpl messageConfig) {
            this.messageConfig = messageConfig != null ? messageConfig.build() : null;
        }

        @Override
        public final Builder messageConfig(JourneyCustomMessage messageConfig) {
            this.messageConfig = messageConfig;
            return this;
        }

        public final String getNextActivity() {
            return this.nextActivity;
        }

        public final void setNextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
        }

        @Override
        public final Builder nextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateVersion() {
            return this.templateVersion;
        }

        public final void setTemplateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
        }

        @Override
        public final Builder templateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
            return this;
        }

        public CustomMessageActivity build() {
            return new CustomMessageActivity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomMessageActivity> {
        public Builder deliveryUri(String var1);

        public Builder endpointTypesWithStrings(Collection<String> var1);

        public Builder endpointTypesWithStrings(String ... var1);

        public Builder endpointTypes(Collection<EndpointTypesElement> var1);

        public Builder endpointTypes(EndpointTypesElement ... var1);

        public Builder messageConfig(JourneyCustomMessage var1);

        default public Builder messageConfig(Consumer<JourneyCustomMessage.Builder> messageConfig) {
            return this.messageConfig((JourneyCustomMessage)((JourneyCustomMessage.Builder)JourneyCustomMessage.builder().applyMutation(messageConfig)).build());
        }

        public Builder nextActivity(String var1);

        public Builder templateName(String var1);

        public Builder templateVersion(String var1);
    }
}

