/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.EndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.ListOfEndpointResponseCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointsResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointsResponse> {
    private static final SdkField<List<EndpointResponse>> ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Item").getter(EndpointsResponse.getter(EndpointsResponse::item)).setter(EndpointsResponse.setter(Builder::item)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EndpointsResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<EndpointResponse> item;

    private EndpointsResponse(BuilderImpl builder) {
        this.item = builder.item;
    }

    public final boolean hasItem() {
        return this.item != null && !(this.item instanceof SdkAutoConstructList);
    }

    public final List<EndpointResponse> item() {
        return this.item;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItem() ? this.item() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointsResponse)) {
            return false;
        }
        EndpointsResponse other = (EndpointsResponse)obj;
        return this.hasItem() == other.hasItem() && Objects.equals(this.item(), other.item());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointsResponse").add("Item", this.hasItem() ? this.item() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<EndpointResponse>>> map = new HashMap<String, SdkField<List<EndpointResponse>>>();
        map.put("Item", ITEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointsResponse, T> g) {
        return obj -> g.apply((EndpointsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EndpointResponse> item = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointsResponse model) {
            this.item(model.item);
        }

        public final List<EndpointResponse.Builder> getItem() {
            List<EndpointResponse.Builder> result = ListOfEndpointResponseCopier.copyToBuilder(this.item);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItem(Collection<EndpointResponse.BuilderImpl> item) {
            this.item = ListOfEndpointResponseCopier.copyFromBuilder(item);
        }

        @Override
        public final Builder item(Collection<EndpointResponse> item) {
            this.item = ListOfEndpointResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(EndpointResponse ... item) {
            this.item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<EndpointResponse.Builder> ... item) {
            this.item(Stream.of(item).map(c -> (EndpointResponse)((EndpointResponse.Builder)EndpointResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EndpointsResponse build() {
            return new EndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointsResponse> {
        public Builder item(Collection<EndpointResponse> var1);

        public Builder item(EndpointResponse ... var1);

        public Builder item(Consumer<EndpointResponse.Builder> ... var1);
    }
}

