/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JourneyExecutionMetricsResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JourneyExecutionMetricsResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(JourneyExecutionMetricsResponse.getter(JourneyExecutionMetricsResponse::applicationId)).setter(JourneyExecutionMetricsResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> JOURNEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JourneyId").getter(JourneyExecutionMetricsResponse.getter(JourneyExecutionMetricsResponse::journeyId)).setter(JourneyExecutionMetricsResponse.setter(Builder::journeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyId").build()}).build();
    private static final SdkField<String> LAST_EVALUATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastEvaluatedTime").getter(JourneyExecutionMetricsResponse.getter(JourneyExecutionMetricsResponse::lastEvaluatedTime)).setter(JourneyExecutionMetricsResponse.setter(Builder::lastEvaluatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedTime").build()}).build();
    private static final SdkField<Map<String, String>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Metrics").getter(JourneyExecutionMetricsResponse.getter(JourneyExecutionMetricsResponse::metrics)).setter(JourneyExecutionMetricsResponse.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, JOURNEY_ID_FIELD, LAST_EVALUATED_TIME_FIELD, METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JourneyExecutionMetricsResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String journeyId;
    private final String lastEvaluatedTime;
    private final Map<String, String> metrics;

    private JourneyExecutionMetricsResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.journeyId = builder.journeyId;
        this.lastEvaluatedTime = builder.lastEvaluatedTime;
        this.metrics = builder.metrics;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String journeyId() {
        return this.journeyId;
    }

    public final String lastEvaluatedTime() {
        return this.lastEvaluatedTime;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metrics() {
        return this.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.journeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneyExecutionMetricsResponse)) {
            return false;
        }
        JourneyExecutionMetricsResponse other = (JourneyExecutionMetricsResponse)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.journeyId(), other.journeyId()) && Objects.equals(this.lastEvaluatedTime(), other.lastEvaluatedTime()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics());
    }

    public final String toString() {
        return ToString.builder((String)"JourneyExecutionMetricsResponse").add("ApplicationId", (Object)this.applicationId()).add("JourneyId", (Object)this.journeyId()).add("LastEvaluatedTime", (Object)this.lastEvaluatedTime()).add("Metrics", this.hasMetrics() ? this.metrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "JourneyId": {
                return Optional.ofNullable(clazz.cast(this.journeyId()));
            }
            case "LastEvaluatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedTime()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("JourneyId", JOURNEY_ID_FIELD);
        map.put("LastEvaluatedTime", LAST_EVALUATED_TIME_FIELD);
        map.put("Metrics", METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JourneyExecutionMetricsResponse, T> g) {
        return obj -> g.apply((JourneyExecutionMetricsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String journeyId;
        private String lastEvaluatedTime;
        private Map<String, String> metrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JourneyExecutionMetricsResponse model) {
            this.applicationId(model.applicationId);
            this.journeyId(model.journeyId);
            this.lastEvaluatedTime(model.lastEvaluatedTime);
            this.metrics(model.metrics);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getJourneyId() {
            return this.journeyId;
        }

        public final void setJourneyId(String journeyId) {
            this.journeyId = journeyId;
        }

        @Override
        public final Builder journeyId(String journeyId) {
            this.journeyId = journeyId;
            return this;
        }

        public final String getLastEvaluatedTime() {
            return this.lastEvaluatedTime;
        }

        public final void setLastEvaluatedTime(String lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
        }

        @Override
        public final Builder lastEvaluatedTime(String lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
            return this;
        }

        public final Map<String, String> getMetrics() {
            if (this.metrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metrics;
        }

        public final void setMetrics(Map<String, String> metrics) {
            this.metrics = MapOf__stringCopier.copy(metrics);
        }

        @Override
        public final Builder metrics(Map<String, String> metrics) {
            this.metrics = MapOf__stringCopier.copy(metrics);
            return this;
        }

        public JourneyExecutionMetricsResponse build() {
            return new JourneyExecutionMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JourneyExecutionMetricsResponse> {
        public Builder applicationId(String var1);

        public Builder journeyId(String var1);

        public Builder lastEvaluatedTime(String var1);

        public Builder metrics(Map<String, String> var1);
    }
}

