/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.Duration;
import software.amazon.awssdk.services.pinpoint.model.RecencyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecencyDimension
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecencyDimension> {
    private static final SdkField<String> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecencyDimension.getter(RecencyDimension::durationAsString)).setter(RecencyDimension.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<String> RECENCY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecencyDimension.getter(RecencyDimension::recencyTypeAsString)).setter(RecencyDimension.setter(Builder::recencyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecencyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD, RECENCY_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String duration;
    private final String recencyType;

    private RecencyDimension(BuilderImpl builder) {
        this.duration = builder.duration;
        this.recencyType = builder.recencyType;
    }

    public Duration duration() {
        return Duration.fromValue(this.duration);
    }

    public String durationAsString() {
        return this.duration;
    }

    public RecencyType recencyType() {
        return RecencyType.fromValue(this.recencyType);
    }

    public String recencyTypeAsString() {
        return this.recencyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.durationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recencyTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecencyDimension)) {
            return false;
        }
        RecencyDimension other = (RecencyDimension)obj;
        return Objects.equals(this.durationAsString(), other.durationAsString()) && Objects.equals(this.recencyTypeAsString(), other.recencyTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"RecencyDimension").add("Duration", (Object)this.durationAsString()).add("RecencyType", (Object)this.recencyTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.durationAsString()));
            }
            case "RecencyType": {
                return Optional.ofNullable(clazz.cast(this.recencyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecencyDimension, T> g) {
        return obj -> g.apply((RecencyDimension)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String duration;
        private String recencyType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecencyDimension model) {
            this.duration(model.duration);
            this.recencyType(model.recencyType);
        }

        public final String getDurationAsString() {
            return this.duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public final Builder duration(Duration duration) {
            this.duration(duration.toString());
            return this;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        public final String getRecencyTypeAsString() {
            return this.recencyType;
        }

        @Override
        public final Builder recencyType(String recencyType) {
            this.recencyType = recencyType;
            return this;
        }

        @Override
        public final Builder recencyType(RecencyType recencyType) {
            this.recencyType(recencyType.toString());
            return this;
        }

        public final void setRecencyType(String recencyType) {
            this.recencyType = recencyType;
        }

        public RecencyDimension build() {
            return new RecencyDimension(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecencyDimension> {
        public Builder duration(String var1);

        public Builder duration(Duration var1);

        public Builder recencyType(String var1);

        public Builder recencyType(RecencyType var1);
    }
}

