/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.JourneyStateRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateJourneyStateRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateJourneyStateRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(UpdateJourneyStateRequest.getter(UpdateJourneyStateRequest::applicationId)).setter(UpdateJourneyStateRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<String> JOURNEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JourneyId").getter(UpdateJourneyStateRequest.getter(UpdateJourneyStateRequest::journeyId)).setter(UpdateJourneyStateRequest.setter(Builder::journeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("journey-id").build()}).build();
    private static final SdkField<JourneyStateRequest> JOURNEY_STATE_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JourneyStateRequest").getter(UpdateJourneyStateRequest.getter(UpdateJourneyStateRequest::journeyStateRequest)).setter(UpdateJourneyStateRequest.setter(Builder::journeyStateRequest)).constructor(JourneyStateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyStateRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, JOURNEY_ID_FIELD, JOURNEY_STATE_REQUEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("application-id", APPLICATION_ID_FIELD);
            this.put("journey-id", JOURNEY_ID_FIELD);
            this.put("JourneyStateRequest", JOURNEY_STATE_REQUEST_FIELD);
        }
    });
    private final String applicationId;
    private final String journeyId;
    private final JourneyStateRequest journeyStateRequest;

    private UpdateJourneyStateRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.journeyId = builder.journeyId;
        this.journeyStateRequest = builder.journeyStateRequest;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String journeyId() {
        return this.journeyId;
    }

    public final JourneyStateRequest journeyStateRequest() {
        return this.journeyStateRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.journeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.journeyStateRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJourneyStateRequest)) {
            return false;
        }
        UpdateJourneyStateRequest other = (UpdateJourneyStateRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.journeyId(), other.journeyId()) && Objects.equals(this.journeyStateRequest(), other.journeyStateRequest());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateJourneyStateRequest").add("ApplicationId", (Object)this.applicationId()).add("JourneyId", (Object)this.journeyId()).add("JourneyStateRequest", (Object)this.journeyStateRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "JourneyId": {
                return Optional.ofNullable(clazz.cast(this.journeyId()));
            }
            case "JourneyStateRequest": {
                return Optional.ofNullable(clazz.cast(this.journeyStateRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJourneyStateRequest, T> g) {
        return obj -> g.apply((UpdateJourneyStateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String journeyId;
        private JourneyStateRequest journeyStateRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJourneyStateRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.journeyId(model.journeyId);
            this.journeyStateRequest(model.journeyStateRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getJourneyId() {
            return this.journeyId;
        }

        public final void setJourneyId(String journeyId) {
            this.journeyId = journeyId;
        }

        @Override
        public final Builder journeyId(String journeyId) {
            this.journeyId = journeyId;
            return this;
        }

        public final JourneyStateRequest.Builder getJourneyStateRequest() {
            return this.journeyStateRequest != null ? this.journeyStateRequest.toBuilder() : null;
        }

        public final void setJourneyStateRequest(JourneyStateRequest.BuilderImpl journeyStateRequest) {
            this.journeyStateRequest = journeyStateRequest != null ? journeyStateRequest.build() : null;
        }

        @Override
        public final Builder journeyStateRequest(JourneyStateRequest journeyStateRequest) {
            this.journeyStateRequest = journeyStateRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJourneyStateRequest build() {
            return new UpdateJourneyStateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateJourneyStateRequest> {
        public Builder applicationId(String var1);

        public Builder journeyId(String var1);

        public Builder journeyStateRequest(JourneyStateRequest var1);

        default public Builder journeyStateRequest(Consumer<JourneyStateRequest.Builder> journeyStateRequest) {
            return this.journeyStateRequest((JourneyStateRequest)((JourneyStateRequest.Builder)JourneyStateRequest.builder().applyMutation(journeyStateRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

