/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.DeliveryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageResult> {
    private static final SdkField<String> DELIVERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryStatus").getter(MessageResult.getter(MessageResult::deliveryStatusAsString)).setter(MessageResult.setter(Builder::deliveryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStatus").build()}).build();
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(MessageResult.getter(MessageResult::messageId)).setter(MessageResult.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()}).build();
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StatusCode").getter(MessageResult.getter(MessageResult::statusCode)).setter(MessageResult.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(MessageResult.getter(MessageResult::statusMessage)).setter(MessageResult.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> UPDATED_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdatedToken").getter(MessageResult.getter(MessageResult::updatedToken)).setter(MessageResult.setter(Builder::updatedToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STATUS_FIELD, MESSAGE_ID_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, UPDATED_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DeliveryStatus", DELIVERY_STATUS_FIELD);
            this.put("MessageId", MESSAGE_ID_FIELD);
            this.put("StatusCode", STATUS_CODE_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
            this.put("UpdatedToken", UPDATED_TOKEN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String deliveryStatus;
    private final String messageId;
    private final Integer statusCode;
    private final String statusMessage;
    private final String updatedToken;

    private MessageResult(BuilderImpl builder) {
        this.deliveryStatus = builder.deliveryStatus;
        this.messageId = builder.messageId;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.updatedToken = builder.updatedToken;
    }

    public final DeliveryStatus deliveryStatus() {
        return DeliveryStatus.fromValue(this.deliveryStatus);
    }

    public final String deliveryStatusAsString() {
        return this.deliveryStatus;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final Integer statusCode() {
        return this.statusCode;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String updatedToken() {
        return this.updatedToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageResult)) {
            return false;
        }
        MessageResult other = (MessageResult)obj;
        return Objects.equals(this.deliveryStatusAsString(), other.deliveryStatusAsString()) && Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.updatedToken(), other.updatedToken());
    }

    public final String toString() {
        return ToString.builder((String)"MessageResult").add("DeliveryStatus", (Object)this.deliveryStatusAsString()).add("MessageId", (Object)this.messageId()).add("StatusCode", (Object)this.statusCode()).add("StatusMessage", (Object)this.statusMessage()).add("UpdatedToken", (Object)this.updatedToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStatus": {
                return Optional.ofNullable(clazz.cast(this.deliveryStatusAsString()));
            }
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "UpdatedToken": {
                return Optional.ofNullable(clazz.cast(this.updatedToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MessageResult, T> g) {
        return obj -> g.apply((MessageResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryStatus;
        private String messageId;
        private Integer statusCode;
        private String statusMessage;
        private String updatedToken;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageResult model) {
            this.deliveryStatus(model.deliveryStatus);
            this.messageId(model.messageId);
            this.statusCode(model.statusCode);
            this.statusMessage(model.statusMessage);
            this.updatedToken(model.updatedToken);
        }

        public final String getDeliveryStatus() {
            return this.deliveryStatus;
        }

        public final void setDeliveryStatus(String deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
        }

        @Override
        public final Builder deliveryStatus(String deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
            return this;
        }

        @Override
        public final Builder deliveryStatus(DeliveryStatus deliveryStatus) {
            this.deliveryStatus(deliveryStatus == null ? null : deliveryStatus.toString());
            return this;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final Integer getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getUpdatedToken() {
            return this.updatedToken;
        }

        public final void setUpdatedToken(String updatedToken) {
            this.updatedToken = updatedToken;
        }

        @Override
        public final Builder updatedToken(String updatedToken) {
            this.updatedToken = updatedToken;
            return this;
        }

        public MessageResult build() {
            return new MessageResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageResult> {
        public Builder deliveryStatus(String var1);

        public Builder deliveryStatus(DeliveryStatus var1);

        public Builder messageId(String var1);

        public Builder statusCode(Integer var1);

        public Builder statusMessage(String var1);

        public Builder updatedToken(String var1);
    }
}

