/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.EndpointItemResponse;
import software.amazon.awssdk.services.pinpoint.model.EventItemResponse;
import software.amazon.awssdk.services.pinpoint.model.MapOfEventItemResponseCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ItemResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ItemResponse> {
    private static final SdkField<EndpointItemResponse> ENDPOINT_ITEM_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointItemResponse").getter(ItemResponse.getter(ItemResponse::endpointItemResponse)).setter(ItemResponse.setter(Builder::endpointItemResponse)).constructor(EndpointItemResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointItemResponse").build()}).build();
    private static final SdkField<Map<String, EventItemResponse>> EVENTS_ITEM_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("EventsItemResponse").getter(ItemResponse.getter(ItemResponse::eventsItemResponse)).setter(ItemResponse.setter(Builder::eventsItemResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsItemResponse").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventItemResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ITEM_RESPONSE_FIELD, EVENTS_ITEM_RESPONSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EndpointItemResponse", ENDPOINT_ITEM_RESPONSE_FIELD);
            this.put("EventsItemResponse", EVENTS_ITEM_RESPONSE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final EndpointItemResponse endpointItemResponse;
    private final Map<String, EventItemResponse> eventsItemResponse;

    private ItemResponse(BuilderImpl builder) {
        this.endpointItemResponse = builder.endpointItemResponse;
        this.eventsItemResponse = builder.eventsItemResponse;
    }

    public final EndpointItemResponse endpointItemResponse() {
        return this.endpointItemResponse;
    }

    public final boolean hasEventsItemResponse() {
        return this.eventsItemResponse != null && !(this.eventsItemResponse instanceof SdkAutoConstructMap);
    }

    public final Map<String, EventItemResponse> eventsItemResponse() {
        return this.eventsItemResponse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointItemResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventsItemResponse() ? this.eventsItemResponse() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemResponse)) {
            return false;
        }
        ItemResponse other = (ItemResponse)obj;
        return Objects.equals(this.endpointItemResponse(), other.endpointItemResponse()) && this.hasEventsItemResponse() == other.hasEventsItemResponse() && Objects.equals(this.eventsItemResponse(), other.eventsItemResponse());
    }

    public final String toString() {
        return ToString.builder((String)"ItemResponse").add("EndpointItemResponse", (Object)this.endpointItemResponse()).add("EventsItemResponse", this.hasEventsItemResponse() ? this.eventsItemResponse() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointItemResponse": {
                return Optional.ofNullable(clazz.cast(this.endpointItemResponse()));
            }
            case "EventsItemResponse": {
                return Optional.ofNullable(clazz.cast(this.eventsItemResponse()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ItemResponse, T> g) {
        return obj -> g.apply((ItemResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EndpointItemResponse endpointItemResponse;
        private Map<String, EventItemResponse> eventsItemResponse = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ItemResponse model) {
            this.endpointItemResponse(model.endpointItemResponse);
            this.eventsItemResponse(model.eventsItemResponse);
        }

        public final EndpointItemResponse.Builder getEndpointItemResponse() {
            return this.endpointItemResponse != null ? this.endpointItemResponse.toBuilder() : null;
        }

        public final void setEndpointItemResponse(EndpointItemResponse.BuilderImpl endpointItemResponse) {
            this.endpointItemResponse = endpointItemResponse != null ? endpointItemResponse.build() : null;
        }

        @Override
        public final Builder endpointItemResponse(EndpointItemResponse endpointItemResponse) {
            this.endpointItemResponse = endpointItemResponse;
            return this;
        }

        public final Map<String, EventItemResponse.Builder> getEventsItemResponse() {
            Map<String, EventItemResponse.Builder> result = MapOfEventItemResponseCopier.copyToBuilder(this.eventsItemResponse);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEventsItemResponse(Map<String, EventItemResponse.BuilderImpl> eventsItemResponse) {
            this.eventsItemResponse = MapOfEventItemResponseCopier.copyFromBuilder(eventsItemResponse);
        }

        @Override
        public final Builder eventsItemResponse(Map<String, EventItemResponse> eventsItemResponse) {
            this.eventsItemResponse = MapOfEventItemResponseCopier.copy(eventsItemResponse);
            return this;
        }

        public ItemResponse build() {
            return new ItemResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ItemResponse> {
        public Builder endpointItemResponse(EndpointItemResponse var1);

        default public Builder endpointItemResponse(Consumer<EndpointItemResponse.Builder> endpointItemResponse) {
            return this.endpointItemResponse((EndpointItemResponse)((EndpointItemResponse.Builder)EndpointItemResponse.builder().applyMutation(endpointItemResponse)).build());
        }

        public Builder eventsItemResponse(Map<String, EventItemResponse> var1);
    }
}

