/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailChannelRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailChannelRequest> {
    private static final SdkField<String> CONFIGURATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSet").getter(EmailChannelRequest.getter(EmailChannelRequest::configurationSet)).setter(EmailChannelRequest.setter(Builder::configurationSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSet").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(EmailChannelRequest.getter(EmailChannelRequest::enabled)).setter(EmailChannelRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> FROM_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromAddress").getter(EmailChannelRequest.getter(EmailChannelRequest::fromAddress)).setter(EmailChannelRequest.setter(Builder::fromAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromAddress").build()}).build();
    private static final SdkField<String> IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identity").getter(EmailChannelRequest.getter(EmailChannelRequest::identity)).setter(EmailChannelRequest.setter(Builder::identity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identity").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(EmailChannelRequest.getter(EmailChannelRequest::roleArn)).setter(EmailChannelRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> ORCHESTRATION_SENDING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrchestrationSendingRoleArn").getter(EmailChannelRequest.getter(EmailChannelRequest::orchestrationSendingRoleArn)).setter(EmailChannelRequest.setter(Builder::orchestrationSendingRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrchestrationSendingRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_FIELD, ENABLED_FIELD, FROM_ADDRESS_FIELD, IDENTITY_FIELD, ROLE_ARN_FIELD, ORCHESTRATION_SENDING_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConfigurationSet", CONFIGURATION_SET_FIELD);
            this.put("Enabled", ENABLED_FIELD);
            this.put("FromAddress", FROM_ADDRESS_FIELD);
            this.put("Identity", IDENTITY_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("OrchestrationSendingRoleArn", ORCHESTRATION_SENDING_ROLE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String configurationSet;
    private final Boolean enabled;
    private final String fromAddress;
    private final String identity;
    private final String roleArn;
    private final String orchestrationSendingRoleArn;

    private EmailChannelRequest(BuilderImpl builder) {
        this.configurationSet = builder.configurationSet;
        this.enabled = builder.enabled;
        this.fromAddress = builder.fromAddress;
        this.identity = builder.identity;
        this.roleArn = builder.roleArn;
        this.orchestrationSendingRoleArn = builder.orchestrationSendingRoleArn;
    }

    public final String configurationSet() {
        return this.configurationSet;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String fromAddress() {
        return this.fromAddress;
    }

    public final String identity() {
        return this.identity;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String orchestrationSendingRoleArn() {
        return this.orchestrationSendingRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.orchestrationSendingRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailChannelRequest)) {
            return false;
        }
        EmailChannelRequest other = (EmailChannelRequest)obj;
        return Objects.equals(this.configurationSet(), other.configurationSet()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.fromAddress(), other.fromAddress()) && Objects.equals(this.identity(), other.identity()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.orchestrationSendingRoleArn(), other.orchestrationSendingRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"EmailChannelRequest").add("ConfigurationSet", (Object)this.configurationSet()).add("Enabled", (Object)this.enabled()).add("FromAddress", (Object)this.fromAddress()).add("Identity", (Object)this.identity()).add("RoleArn", (Object)this.roleArn()).add("OrchestrationSendingRoleArn", (Object)this.orchestrationSendingRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSet": {
                return Optional.ofNullable(clazz.cast(this.configurationSet()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "FromAddress": {
                return Optional.ofNullable(clazz.cast(this.fromAddress()));
            }
            case "Identity": {
                return Optional.ofNullable(clazz.cast(this.identity()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "OrchestrationSendingRoleArn": {
                return Optional.ofNullable(clazz.cast(this.orchestrationSendingRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EmailChannelRequest, T> g) {
        return obj -> g.apply((EmailChannelRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationSet;
        private Boolean enabled;
        private String fromAddress;
        private String identity;
        private String roleArn;
        private String orchestrationSendingRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailChannelRequest model) {
            this.configurationSet(model.configurationSet);
            this.enabled(model.enabled);
            this.fromAddress(model.fromAddress);
            this.identity(model.identity);
            this.roleArn(model.roleArn);
            this.orchestrationSendingRoleArn(model.orchestrationSendingRoleArn);
        }

        public final String getConfigurationSet() {
            return this.configurationSet;
        }

        public final void setConfigurationSet(String configurationSet) {
            this.configurationSet = configurationSet;
        }

        @Override
        public final Builder configurationSet(String configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getFromAddress() {
            return this.fromAddress;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final String getIdentity() {
            return this.identity;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getOrchestrationSendingRoleArn() {
            return this.orchestrationSendingRoleArn;
        }

        public final void setOrchestrationSendingRoleArn(String orchestrationSendingRoleArn) {
            this.orchestrationSendingRoleArn = orchestrationSendingRoleArn;
        }

        @Override
        public final Builder orchestrationSendingRoleArn(String orchestrationSendingRoleArn) {
            this.orchestrationSendingRoleArn = orchestrationSendingRoleArn;
            return this;
        }

        public EmailChannelRequest build() {
            return new EmailChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailChannelRequest> {
        public Builder configurationSet(String var1);

        public Builder enabled(Boolean var1);

        public Builder fromAddress(String var1);

        public Builder identity(String var1);

        public Builder roleArn(String var1);

        public Builder orchestrationSendingRoleArn(String var1);
    }
}

