/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.CampaignCustomMessage;
import software.amazon.awssdk.services.pinpoint.model.CampaignEmailMessage;
import software.amazon.awssdk.services.pinpoint.model.CampaignInAppMessage;
import software.amazon.awssdk.services.pinpoint.model.CampaignSmsMessage;
import software.amazon.awssdk.services.pinpoint.model.Message;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageConfiguration> {
    private static final SdkField<Message> ADM_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ADMMessage").getter(MessageConfiguration.getter(MessageConfiguration::admMessage)).setter(MessageConfiguration.setter(Builder::admMessage)).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ADMMessage").build()}).build();
    private static final SdkField<Message> APNS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("APNSMessage").getter(MessageConfiguration.getter(MessageConfiguration::apnsMessage)).setter(MessageConfiguration.setter(Builder::apnsMessage)).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNSMessage").build()}).build();
    private static final SdkField<Message> BAIDU_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BaiduMessage").getter(MessageConfiguration.getter(MessageConfiguration::baiduMessage)).setter(MessageConfiguration.setter(Builder::baiduMessage)).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaiduMessage").build()}).build();
    private static final SdkField<CampaignCustomMessage> CUSTOM_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomMessage").getter(MessageConfiguration.getter(MessageConfiguration::customMessage)).setter(MessageConfiguration.setter(Builder::customMessage)).constructor(CampaignCustomMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomMessage").build()}).build();
    private static final SdkField<Message> DEFAULT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultMessage").getter(MessageConfiguration.getter(MessageConfiguration::defaultMessage)).setter(MessageConfiguration.setter(Builder::defaultMessage)).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultMessage").build()}).build();
    private static final SdkField<CampaignEmailMessage> EMAIL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmailMessage").getter(MessageConfiguration.getter(MessageConfiguration::emailMessage)).setter(MessageConfiguration.setter(Builder::emailMessage)).constructor(CampaignEmailMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()}).build();
    private static final SdkField<Message> GCM_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GCMMessage").getter(MessageConfiguration.getter(MessageConfiguration::gcmMessage)).setter(MessageConfiguration.setter(Builder::gcmMessage)).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GCMMessage").build()}).build();
    private static final SdkField<CampaignSmsMessage> SMS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SMSMessage").getter(MessageConfiguration.getter(MessageConfiguration::smsMessage)).setter(MessageConfiguration.setter(Builder::smsMessage)).constructor(CampaignSmsMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSMessage").build()}).build();
    private static final SdkField<CampaignInAppMessage> IN_APP_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InAppMessage").getter(MessageConfiguration.getter(MessageConfiguration::inAppMessage)).setter(MessageConfiguration.setter(Builder::inAppMessage)).constructor(CampaignInAppMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InAppMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADM_MESSAGE_FIELD, APNS_MESSAGE_FIELD, BAIDU_MESSAGE_FIELD, CUSTOM_MESSAGE_FIELD, DEFAULT_MESSAGE_FIELD, EMAIL_MESSAGE_FIELD, GCM_MESSAGE_FIELD, SMS_MESSAGE_FIELD, IN_APP_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ADMMessage", ADM_MESSAGE_FIELD);
            this.put("APNSMessage", APNS_MESSAGE_FIELD);
            this.put("BaiduMessage", BAIDU_MESSAGE_FIELD);
            this.put("CustomMessage", CUSTOM_MESSAGE_FIELD);
            this.put("DefaultMessage", DEFAULT_MESSAGE_FIELD);
            this.put("EmailMessage", EMAIL_MESSAGE_FIELD);
            this.put("GCMMessage", GCM_MESSAGE_FIELD);
            this.put("SMSMessage", SMS_MESSAGE_FIELD);
            this.put("InAppMessage", IN_APP_MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Message admMessage;
    private final Message apnsMessage;
    private final Message baiduMessage;
    private final CampaignCustomMessage customMessage;
    private final Message defaultMessage;
    private final CampaignEmailMessage emailMessage;
    private final Message gcmMessage;
    private final CampaignSmsMessage smsMessage;
    private final CampaignInAppMessage inAppMessage;

    private MessageConfiguration(BuilderImpl builder) {
        this.admMessage = builder.admMessage;
        this.apnsMessage = builder.apnsMessage;
        this.baiduMessage = builder.baiduMessage;
        this.customMessage = builder.customMessage;
        this.defaultMessage = builder.defaultMessage;
        this.emailMessage = builder.emailMessage;
        this.gcmMessage = builder.gcmMessage;
        this.smsMessage = builder.smsMessage;
        this.inAppMessage = builder.inAppMessage;
    }

    public final Message admMessage() {
        return this.admMessage;
    }

    public final Message apnsMessage() {
        return this.apnsMessage;
    }

    public final Message baiduMessage() {
        return this.baiduMessage;
    }

    public final CampaignCustomMessage customMessage() {
        return this.customMessage;
    }

    public final Message defaultMessage() {
        return this.defaultMessage;
    }

    public final CampaignEmailMessage emailMessage() {
        return this.emailMessage;
    }

    public final Message gcmMessage() {
        return this.gcmMessage;
    }

    public final CampaignSmsMessage smsMessage() {
        return this.smsMessage;
    }

    public final CampaignInAppMessage inAppMessage() {
        return this.inAppMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.admMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.apnsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.baiduMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.customMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.gcmMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.inAppMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageConfiguration)) {
            return false;
        }
        MessageConfiguration other = (MessageConfiguration)obj;
        return Objects.equals(this.admMessage(), other.admMessage()) && Objects.equals(this.apnsMessage(), other.apnsMessage()) && Objects.equals(this.baiduMessage(), other.baiduMessage()) && Objects.equals(this.customMessage(), other.customMessage()) && Objects.equals(this.defaultMessage(), other.defaultMessage()) && Objects.equals(this.emailMessage(), other.emailMessage()) && Objects.equals(this.gcmMessage(), other.gcmMessage()) && Objects.equals(this.smsMessage(), other.smsMessage()) && Objects.equals(this.inAppMessage(), other.inAppMessage());
    }

    public final String toString() {
        return ToString.builder((String)"MessageConfiguration").add("ADMMessage", (Object)this.admMessage()).add("APNSMessage", (Object)this.apnsMessage()).add("BaiduMessage", (Object)this.baiduMessage()).add("CustomMessage", (Object)this.customMessage()).add("DefaultMessage", (Object)this.defaultMessage()).add("EmailMessage", (Object)this.emailMessage()).add("GCMMessage", (Object)this.gcmMessage()).add("SMSMessage", (Object)this.smsMessage()).add("InAppMessage", (Object)this.inAppMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ADMMessage": {
                return Optional.ofNullable(clazz.cast(this.admMessage()));
            }
            case "APNSMessage": {
                return Optional.ofNullable(clazz.cast(this.apnsMessage()));
            }
            case "BaiduMessage": {
                return Optional.ofNullable(clazz.cast(this.baiduMessage()));
            }
            case "CustomMessage": {
                return Optional.ofNullable(clazz.cast(this.customMessage()));
            }
            case "DefaultMessage": {
                return Optional.ofNullable(clazz.cast(this.defaultMessage()));
            }
            case "EmailMessage": {
                return Optional.ofNullable(clazz.cast(this.emailMessage()));
            }
            case "GCMMessage": {
                return Optional.ofNullable(clazz.cast(this.gcmMessage()));
            }
            case "SMSMessage": {
                return Optional.ofNullable(clazz.cast(this.smsMessage()));
            }
            case "InAppMessage": {
                return Optional.ofNullable(clazz.cast(this.inAppMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MessageConfiguration, T> g) {
        return obj -> g.apply((MessageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Message admMessage;
        private Message apnsMessage;
        private Message baiduMessage;
        private CampaignCustomMessage customMessage;
        private Message defaultMessage;
        private CampaignEmailMessage emailMessage;
        private Message gcmMessage;
        private CampaignSmsMessage smsMessage;
        private CampaignInAppMessage inAppMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageConfiguration model) {
            this.admMessage(model.admMessage);
            this.apnsMessage(model.apnsMessage);
            this.baiduMessage(model.baiduMessage);
            this.customMessage(model.customMessage);
            this.defaultMessage(model.defaultMessage);
            this.emailMessage(model.emailMessage);
            this.gcmMessage(model.gcmMessage);
            this.smsMessage(model.smsMessage);
            this.inAppMessage(model.inAppMessage);
        }

        public final Message.Builder getAdmMessage() {
            return this.admMessage != null ? this.admMessage.toBuilder() : null;
        }

        public final void setAdmMessage(Message.BuilderImpl admMessage) {
            this.admMessage = admMessage != null ? admMessage.build() : null;
        }

        @Override
        public final Builder admMessage(Message admMessage) {
            this.admMessage = admMessage;
            return this;
        }

        public final Message.Builder getApnsMessage() {
            return this.apnsMessage != null ? this.apnsMessage.toBuilder() : null;
        }

        public final void setApnsMessage(Message.BuilderImpl apnsMessage) {
            this.apnsMessage = apnsMessage != null ? apnsMessage.build() : null;
        }

        @Override
        public final Builder apnsMessage(Message apnsMessage) {
            this.apnsMessage = apnsMessage;
            return this;
        }

        public final Message.Builder getBaiduMessage() {
            return this.baiduMessage != null ? this.baiduMessage.toBuilder() : null;
        }

        public final void setBaiduMessage(Message.BuilderImpl baiduMessage) {
            this.baiduMessage = baiduMessage != null ? baiduMessage.build() : null;
        }

        @Override
        public final Builder baiduMessage(Message baiduMessage) {
            this.baiduMessage = baiduMessage;
            return this;
        }

        public final CampaignCustomMessage.Builder getCustomMessage() {
            return this.customMessage != null ? this.customMessage.toBuilder() : null;
        }

        public final void setCustomMessage(CampaignCustomMessage.BuilderImpl customMessage) {
            this.customMessage = customMessage != null ? customMessage.build() : null;
        }

        @Override
        public final Builder customMessage(CampaignCustomMessage customMessage) {
            this.customMessage = customMessage;
            return this;
        }

        public final Message.Builder getDefaultMessage() {
            return this.defaultMessage != null ? this.defaultMessage.toBuilder() : null;
        }

        public final void setDefaultMessage(Message.BuilderImpl defaultMessage) {
            this.defaultMessage = defaultMessage != null ? defaultMessage.build() : null;
        }

        @Override
        public final Builder defaultMessage(Message defaultMessage) {
            this.defaultMessage = defaultMessage;
            return this;
        }

        public final CampaignEmailMessage.Builder getEmailMessage() {
            return this.emailMessage != null ? this.emailMessage.toBuilder() : null;
        }

        public final void setEmailMessage(CampaignEmailMessage.BuilderImpl emailMessage) {
            this.emailMessage = emailMessage != null ? emailMessage.build() : null;
        }

        @Override
        public final Builder emailMessage(CampaignEmailMessage emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final Message.Builder getGcmMessage() {
            return this.gcmMessage != null ? this.gcmMessage.toBuilder() : null;
        }

        public final void setGcmMessage(Message.BuilderImpl gcmMessage) {
            this.gcmMessage = gcmMessage != null ? gcmMessage.build() : null;
        }

        @Override
        public final Builder gcmMessage(Message gcmMessage) {
            this.gcmMessage = gcmMessage;
            return this;
        }

        public final CampaignSmsMessage.Builder getSmsMessage() {
            return this.smsMessage != null ? this.smsMessage.toBuilder() : null;
        }

        public final void setSmsMessage(CampaignSmsMessage.BuilderImpl smsMessage) {
            this.smsMessage = smsMessage != null ? smsMessage.build() : null;
        }

        @Override
        public final Builder smsMessage(CampaignSmsMessage smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final CampaignInAppMessage.Builder getInAppMessage() {
            return this.inAppMessage != null ? this.inAppMessage.toBuilder() : null;
        }

        public final void setInAppMessage(CampaignInAppMessage.BuilderImpl inAppMessage) {
            this.inAppMessage = inAppMessage != null ? inAppMessage.build() : null;
        }

        @Override
        public final Builder inAppMessage(CampaignInAppMessage inAppMessage) {
            this.inAppMessage = inAppMessage;
            return this;
        }

        public MessageConfiguration build() {
            return new MessageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageConfiguration> {
        public Builder admMessage(Message var1);

        default public Builder admMessage(Consumer<Message.Builder> admMessage) {
            return this.admMessage((Message)((Message.Builder)Message.builder().applyMutation(admMessage)).build());
        }

        public Builder apnsMessage(Message var1);

        default public Builder apnsMessage(Consumer<Message.Builder> apnsMessage) {
            return this.apnsMessage((Message)((Message.Builder)Message.builder().applyMutation(apnsMessage)).build());
        }

        public Builder baiduMessage(Message var1);

        default public Builder baiduMessage(Consumer<Message.Builder> baiduMessage) {
            return this.baiduMessage((Message)((Message.Builder)Message.builder().applyMutation(baiduMessage)).build());
        }

        public Builder customMessage(CampaignCustomMessage var1);

        default public Builder customMessage(Consumer<CampaignCustomMessage.Builder> customMessage) {
            return this.customMessage((CampaignCustomMessage)((CampaignCustomMessage.Builder)CampaignCustomMessage.builder().applyMutation(customMessage)).build());
        }

        public Builder defaultMessage(Message var1);

        default public Builder defaultMessage(Consumer<Message.Builder> defaultMessage) {
            return this.defaultMessage((Message)((Message.Builder)Message.builder().applyMutation(defaultMessage)).build());
        }

        public Builder emailMessage(CampaignEmailMessage var1);

        default public Builder emailMessage(Consumer<CampaignEmailMessage.Builder> emailMessage) {
            return this.emailMessage((CampaignEmailMessage)((CampaignEmailMessage.Builder)CampaignEmailMessage.builder().applyMutation(emailMessage)).build());
        }

        public Builder gcmMessage(Message var1);

        default public Builder gcmMessage(Consumer<Message.Builder> gcmMessage) {
            return this.gcmMessage((Message)((Message.Builder)Message.builder().applyMutation(gcmMessage)).build());
        }

        public Builder smsMessage(CampaignSmsMessage var1);

        default public Builder smsMessage(Consumer<CampaignSmsMessage.Builder> smsMessage) {
            return this.smsMessage((CampaignSmsMessage)((CampaignSmsMessage.Builder)CampaignSmsMessage.builder().applyMutation(smsMessage)).build());
        }

        public Builder inAppMessage(CampaignInAppMessage var1);

        default public Builder inAppMessage(Consumer<CampaignInAppMessage.Builder> inAppMessage) {
            return this.inAppMessage((CampaignInAppMessage)((CampaignInAppMessage.Builder)CampaignInAppMessage.builder().applyMutation(inAppMessage)).build());
        }
    }
}

