/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.Action;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Message
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Message> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(Message.getter(Message::actionAsString)).setter(Message.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(Message.getter(Message::body)).setter(Message.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> IMAGE_ICON_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageIconUrl").getter(Message.getter(Message::imageIconUrl)).setter(Message.setter(Builder::imageIconUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageIconUrl").build()}).build();
    private static final SdkField<String> IMAGE_SMALL_ICON_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageSmallIconUrl").getter(Message.getter(Message::imageSmallIconUrl)).setter(Message.setter(Builder::imageSmallIconUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSmallIconUrl").build()}).build();
    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageUrl").getter(Message.getter(Message::imageUrl)).setter(Message.setter(Builder::imageUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUrl").build()}).build();
    private static final SdkField<String> JSON_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JsonBody").getter(Message.getter(Message::jsonBody)).setter(Message.setter(Builder::jsonBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonBody").build()}).build();
    private static final SdkField<String> MEDIA_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaUrl").getter(Message.getter(Message::mediaUrl)).setter(Message.setter(Builder::mediaUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaUrl").build()}).build();
    private static final SdkField<String> RAW_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RawContent").getter(Message.getter(Message::rawContent)).setter(Message.setter(Builder::rawContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()}).build();
    private static final SdkField<Boolean> SILENT_PUSH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SilentPush").getter(Message.getter(Message::silentPush)).setter(Message.setter(Builder::silentPush)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SilentPush").build()}).build();
    private static final SdkField<Integer> TIME_TO_LIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeToLive").getter(Message.getter(Message::timeToLive)).setter(Message.setter(Builder::timeToLive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLive").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(Message.getter(Message::title)).setter(Message.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(Message.getter(Message::url)).setter(Message.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BODY_FIELD, IMAGE_ICON_URL_FIELD, IMAGE_SMALL_ICON_URL_FIELD, IMAGE_URL_FIELD, JSON_BODY_FIELD, MEDIA_URL_FIELD, RAW_CONTENT_FIELD, SILENT_PUSH_FIELD, TIME_TO_LIVE_FIELD, TITLE_FIELD, URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Action", ACTION_FIELD);
            this.put("Body", BODY_FIELD);
            this.put("ImageIconUrl", IMAGE_ICON_URL_FIELD);
            this.put("ImageSmallIconUrl", IMAGE_SMALL_ICON_URL_FIELD);
            this.put("ImageUrl", IMAGE_URL_FIELD);
            this.put("JsonBody", JSON_BODY_FIELD);
            this.put("MediaUrl", MEDIA_URL_FIELD);
            this.put("RawContent", RAW_CONTENT_FIELD);
            this.put("SilentPush", SILENT_PUSH_FIELD);
            this.put("TimeToLive", TIME_TO_LIVE_FIELD);
            this.put("Title", TITLE_FIELD);
            this.put("Url", URL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String action;
    private final String body;
    private final String imageIconUrl;
    private final String imageSmallIconUrl;
    private final String imageUrl;
    private final String jsonBody;
    private final String mediaUrl;
    private final String rawContent;
    private final Boolean silentPush;
    private final Integer timeToLive;
    private final String title;
    private final String url;

    private Message(BuilderImpl builder) {
        this.action = builder.action;
        this.body = builder.body;
        this.imageIconUrl = builder.imageIconUrl;
        this.imageSmallIconUrl = builder.imageSmallIconUrl;
        this.imageUrl = builder.imageUrl;
        this.jsonBody = builder.jsonBody;
        this.mediaUrl = builder.mediaUrl;
        this.rawContent = builder.rawContent;
        this.silentPush = builder.silentPush;
        this.timeToLive = builder.timeToLive;
        this.title = builder.title;
        this.url = builder.url;
    }

    public final Action action() {
        return Action.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String body() {
        return this.body;
    }

    public final String imageIconUrl() {
        return this.imageIconUrl;
    }

    public final String imageSmallIconUrl() {
        return this.imageSmallIconUrl;
    }

    public final String imageUrl() {
        return this.imageUrl;
    }

    public final String jsonBody() {
        return this.jsonBody;
    }

    public final String mediaUrl() {
        return this.mediaUrl;
    }

    public final String rawContent() {
        return this.rawContent;
    }

    public final Boolean silentPush() {
        return this.silentPush;
    }

    public final Integer timeToLive() {
        return this.timeToLive;
    }

    public final String title() {
        return this.title;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSmallIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.silentPush());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.imageIconUrl(), other.imageIconUrl()) && Objects.equals(this.imageSmallIconUrl(), other.imageSmallIconUrl()) && Objects.equals(this.imageUrl(), other.imageUrl()) && Objects.equals(this.jsonBody(), other.jsonBody()) && Objects.equals(this.mediaUrl(), other.mediaUrl()) && Objects.equals(this.rawContent(), other.rawContent()) && Objects.equals(this.silentPush(), other.silentPush()) && Objects.equals(this.timeToLive(), other.timeToLive()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"Message").add("Action", (Object)this.actionAsString()).add("Body", (Object)this.body()).add("ImageIconUrl", (Object)this.imageIconUrl()).add("ImageSmallIconUrl", (Object)this.imageSmallIconUrl()).add("ImageUrl", (Object)this.imageUrl()).add("JsonBody", (Object)this.jsonBody()).add("MediaUrl", (Object)this.mediaUrl()).add("RawContent", (Object)this.rawContent()).add("SilentPush", (Object)this.silentPush()).add("TimeToLive", (Object)this.timeToLive()).add("Title", (Object)this.title()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "ImageIconUrl": {
                return Optional.ofNullable(clazz.cast(this.imageIconUrl()));
            }
            case "ImageSmallIconUrl": {
                return Optional.ofNullable(clazz.cast(this.imageSmallIconUrl()));
            }
            case "ImageUrl": {
                return Optional.ofNullable(clazz.cast(this.imageUrl()));
            }
            case "JsonBody": {
                return Optional.ofNullable(clazz.cast(this.jsonBody()));
            }
            case "MediaUrl": {
                return Optional.ofNullable(clazz.cast(this.mediaUrl()));
            }
            case "RawContent": {
                return Optional.ofNullable(clazz.cast(this.rawContent()));
            }
            case "SilentPush": {
                return Optional.ofNullable(clazz.cast(this.silentPush()));
            }
            case "TimeToLive": {
                return Optional.ofNullable(clazz.cast(this.timeToLive()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String body;
        private String imageIconUrl;
        private String imageSmallIconUrl;
        private String imageUrl;
        private String jsonBody;
        private String mediaUrl;
        private String rawContent;
        private Boolean silentPush;
        private Integer timeToLive;
        private String title;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            this.action(model.action);
            this.body(model.body);
            this.imageIconUrl(model.imageIconUrl);
            this.imageSmallIconUrl(model.imageSmallIconUrl);
            this.imageUrl(model.imageUrl);
            this.jsonBody(model.jsonBody);
            this.mediaUrl(model.mediaUrl);
            this.rawContent(model.rawContent);
            this.silentPush(model.silentPush);
            this.timeToLive(model.timeToLive);
            this.title(model.title);
            this.url(model.url);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getImageIconUrl() {
            return this.imageIconUrl;
        }

        public final void setImageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
        }

        @Override
        public final Builder imageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
            return this;
        }

        public final String getImageSmallIconUrl() {
            return this.imageSmallIconUrl;
        }

        public final void setImageSmallIconUrl(String imageSmallIconUrl) {
            this.imageSmallIconUrl = imageSmallIconUrl;
        }

        @Override
        public final Builder imageSmallIconUrl(String imageSmallIconUrl) {
            this.imageSmallIconUrl = imageSmallIconUrl;
            return this;
        }

        public final String getImageUrl() {
            return this.imageUrl;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final String getJsonBody() {
            return this.jsonBody;
        }

        public final void setJsonBody(String jsonBody) {
            this.jsonBody = jsonBody;
        }

        @Override
        public final Builder jsonBody(String jsonBody) {
            this.jsonBody = jsonBody;
            return this;
        }

        public final String getMediaUrl() {
            return this.mediaUrl;
        }

        public final void setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        @Override
        public final Builder mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public final String getRawContent() {
            return this.rawContent;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final Boolean getSilentPush() {
            return this.silentPush;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final Integer getTimeToLive() {
            return this.timeToLive;
        }

        public final void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }

        @Override
        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public Message build() {
            return new Message(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Message> {
        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder body(String var1);

        public Builder imageIconUrl(String var1);

        public Builder imageSmallIconUrl(String var1);

        public Builder imageUrl(String var1);

        public Builder jsonBody(String var1);

        public Builder mediaUrl(String var1);

        public Builder rawContent(String var1);

        public Builder silentPush(Boolean var1);

        public Builder timeToLive(Integer var1);

        public Builder title(String var1);

        public Builder url(String var1);
    }
}

