/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a specific version of a message template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateVersionResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateVersionResponse.Builder, TemplateVersionResponse> {
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(TemplateVersionResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> DEFAULT_SUBSTITUTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultSubstitutions").getter(getter(TemplateVersionResponse::defaultSubstitutions))
            .setter(setter(Builder::defaultSubstitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubstitutions").build())
            .build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedDate").getter(getter(TemplateVersionResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateDescription").getter(getter(TemplateVersionResponse::templateDescription))
            .setter(setter(Builder::templateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build())
            .build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(TemplateVersionResponse::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateType").getter(getter(TemplateVersionResponse::templateType))
            .setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(TemplateVersionResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_FIELD,
            DEFAULT_SUBSTITUTIONS_FIELD, LAST_MODIFIED_DATE_FIELD, TEMPLATE_DESCRIPTION_FIELD, TEMPLATE_NAME_FIELD,
            TEMPLATE_TYPE_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String creationDate;

    private final String defaultSubstitutions;

    private final String lastModifiedDate;

    private final String templateDescription;

    private final String templateName;

    private final String templateType;

    private final String version;

    private TemplateVersionResponse(BuilderImpl builder) {
        this.creationDate = builder.creationDate;
        this.defaultSubstitutions = builder.defaultSubstitutions;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.templateDescription = builder.templateDescription;
        this.templateName = builder.templateName;
        this.templateType = builder.templateType;
        this.version = builder.version;
    }

    /**
     * <p>
     * The date, in ISO 8601 format, when the version of the message template was created.
     * </p>
     * 
     * @return The date, in ISO 8601 format, when the version of the message template was created.
     */
    public final String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * A JSON object that specifies the default values that are used for message variables in the version of the message
     * template. This object is a set of key-value pairs. Each key defines a message variable in the template. The
     * corresponding value defines the default value for that variable.
     * </p>
     * 
     * @return A JSON object that specifies the default values that are used for message variables in the version of the
     *         message template. This object is a set of key-value pairs. Each key defines a message variable in the
     *         template. The corresponding value defines the default value for that variable.
     */
    public final String defaultSubstitutions() {
        return defaultSubstitutions;
    }

    /**
     * <p>
     * The date, in ISO 8601 format, when the version of the message template was last modified.
     * </p>
     * 
     * @return The date, in ISO 8601 format, when the version of the message template was last modified.
     */
    public final String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The custom description of the version of the message template.
     * </p>
     * 
     * @return The custom description of the version of the message template.
     */
    public final String templateDescription() {
        return templateDescription;
    }

    /**
     * <p>
     * The name of the message template.
     * </p>
     * 
     * @return The name of the message template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The type of channel that the message template is designed for. Possible values are: EMAIL, PUSH, SMS, and VOICE.
     * </p>
     * 
     * @return The type of channel that the message template is designed for. Possible values are: EMAIL, PUSH, SMS, and
     *         VOICE.
     */
    public final String templateType() {
        return templateType;
    }

    /**
     * <p>
     * The unique identifier for the version of the message template. This value is an integer that Amazon Pinpoint
     * automatically increments and assigns to each new version of a template.
     * </p>
     * 
     * @return The unique identifier for the version of the message template. This value is an integer that Amazon
     *         Pinpoint automatically increments and assigns to each new version of a template.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSubstitutions());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateType());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateVersionResponse)) {
            return false;
        }
        TemplateVersionResponse other = (TemplateVersionResponse) obj;
        return Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(defaultSubstitutions(), other.defaultSubstitutions())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(templateDescription(), other.templateDescription())
                && Objects.equals(templateName(), other.templateName()) && Objects.equals(templateType(), other.templateType())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateVersionResponse").add("CreationDate", creationDate())
                .add("DefaultSubstitutions", defaultSubstitutions()).add("LastModifiedDate", lastModifiedDate())
                .add("TemplateDescription", templateDescription()).add("TemplateName", templateName())
                .add("TemplateType", templateType()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "DefaultSubstitutions":
            return Optional.ofNullable(clazz.cast(defaultSubstitutions()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "TemplateDescription":
            return Optional.ofNullable(clazz.cast(templateDescription()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "TemplateType":
            return Optional.ofNullable(clazz.cast(templateType()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateVersionResponse, T> g) {
        return obj -> g.apply((TemplateVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateVersionResponse> {
        /**
         * <p>
         * The date, in ISO 8601 format, when the version of the message template was created.
         * </p>
         * 
         * @param creationDate
         *        The date, in ISO 8601 format, when the version of the message template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * A JSON object that specifies the default values that are used for message variables in the version of the
         * message template. This object is a set of key-value pairs. Each key defines a message variable in the
         * template. The corresponding value defines the default value for that variable.
         * </p>
         * 
         * @param defaultSubstitutions
         *        A JSON object that specifies the default values that are used for message variables in the version of
         *        the message template. This object is a set of key-value pairs. Each key defines a message variable in
         *        the template. The corresponding value defines the default value for that variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSubstitutions(String defaultSubstitutions);

        /**
         * <p>
         * The date, in ISO 8601 format, when the version of the message template was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date, in ISO 8601 format, when the version of the message template was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * The custom description of the version of the message template.
         * </p>
         * 
         * @param templateDescription
         *        The custom description of the version of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateDescription(String templateDescription);

        /**
         * <p>
         * The name of the message template.
         * </p>
         * 
         * @param templateName
         *        The name of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The type of channel that the message template is designed for. Possible values are: EMAIL, PUSH, SMS, and
         * VOICE.
         * </p>
         * 
         * @param templateType
         *        The type of channel that the message template is designed for. Possible values are: EMAIL, PUSH, SMS,
         *        and VOICE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The unique identifier for the version of the message template. This value is an integer that Amazon Pinpoint
         * automatically increments and assigns to each new version of a template.
         * </p>
         * 
         * @param version
         *        The unique identifier for the version of the message template. This value is an integer that Amazon
         *        Pinpoint automatically increments and assigns to each new version of a template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String creationDate;

        private String defaultSubstitutions;

        private String lastModifiedDate;

        private String templateDescription;

        private String templateName;

        private String templateType;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateVersionResponse model) {
            creationDate(model.creationDate);
            defaultSubstitutions(model.defaultSubstitutions);
            lastModifiedDate(model.lastModifiedDate);
            templateDescription(model.templateDescription);
            templateName(model.templateName);
            templateType(model.templateType);
            version(model.version);
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDefaultSubstitutions() {
            return defaultSubstitutions;
        }

        public final void setDefaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
        }

        @Override
        public final Builder defaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getTemplateDescription() {
            return templateDescription;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public TemplateVersionResponse build() {
            return new TemplateVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
