/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Layout {
    BOTTOM_BANNER("BOTTOM_BANNER"),
    TOP_BANNER("TOP_BANNER"),
    OVERLAYS("OVERLAYS"),
    MOBILE_FEED("MOBILE_FEED"),
    MIDDLE_BANNER("MIDDLE_BANNER"),
    CAROUSEL("CAROUSEL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Layout> VALUE_MAP;
    private final String value;

    private Layout(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Layout fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Layout> knownValues() {
        EnumSet<Layout> knownValues = EnumSet.allOf(Layout.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Layout.class, Layout::toString);
    }
}

