/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.pinpoint.DefaultPinpointBaseClientBuilder;
import software.amazon.awssdk.services.pinpoint.DefaultPinpointClient;
import software.amazon.awssdk.services.pinpoint.PinpointClient;
import software.amazon.awssdk.services.pinpoint.PinpointClientBuilder;
import software.amazon.awssdk.services.pinpoint.PinpointServiceClientConfiguration;
import software.amazon.awssdk.services.pinpoint.endpoints.PinpointEndpointProvider;

@SdkInternalApi
final class DefaultPinpointClientBuilder
extends DefaultPinpointBaseClientBuilder<PinpointClientBuilder, PinpointClient>
implements PinpointClientBuilder {
    DefaultPinpointClientBuilder() {
    }

    @Override
    public DefaultPinpointClientBuilder endpointProvider(PinpointEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PinpointClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultPinpointClientBuilder.validateClientOptions(clientConfiguration);
        PinpointServiceClientConfiguration serviceClientConfiguration = PinpointServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultPinpointClient(serviceClientConfiguration, clientConfiguration);
    }
}

