/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.CampaignHook;
import software.amazon.awssdk.services.pinpoint.model.CampaignLimits;
import software.amazon.awssdk.services.pinpoint.model.QuietTime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSettingsResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationSettingsResource> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(ApplicationSettingsResource.getter(ApplicationSettingsResource::applicationId)).setter(ApplicationSettingsResource.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<CampaignHook> CAMPAIGN_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CampaignHook").getter(ApplicationSettingsResource.getter(ApplicationSettingsResource::campaignHook)).setter(ApplicationSettingsResource.setter(Builder::campaignHook)).constructor(CampaignHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignHook").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedDate").getter(ApplicationSettingsResource.getter(ApplicationSettingsResource::lastModifiedDate)).setter(ApplicationSettingsResource.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<CampaignLimits> LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Limits").getter(ApplicationSettingsResource.getter(ApplicationSettingsResource::limits)).setter(ApplicationSettingsResource.setter(Builder::limits)).constructor(CampaignLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build()}).build();
    private static final SdkField<QuietTime> QUIET_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QuietTime").getter(ApplicationSettingsResource.getter(ApplicationSettingsResource::quietTime)).setter(ApplicationSettingsResource.setter(Builder::quietTime)).constructor(QuietTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuietTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CAMPAIGN_HOOK_FIELD, LAST_MODIFIED_DATE_FIELD, LIMITS_FIELD, QUIET_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final CampaignHook campaignHook;
    private final String lastModifiedDate;
    private final CampaignLimits limits;
    private final QuietTime quietTime;

    private ApplicationSettingsResource(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.campaignHook = builder.campaignHook;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.limits = builder.limits;
        this.quietTime = builder.quietTime;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final CampaignHook campaignHook() {
        return this.campaignHook;
    }

    public final String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final CampaignLimits limits() {
        return this.limits;
    }

    public final QuietTime quietTime() {
        return this.quietTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignHook());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.limits());
        hashCode = 31 * hashCode + Objects.hashCode(this.quietTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSettingsResource)) {
            return false;
        }
        ApplicationSettingsResource other = (ApplicationSettingsResource)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.campaignHook(), other.campaignHook()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.limits(), other.limits()) && Objects.equals(this.quietTime(), other.quietTime());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationSettingsResource").add("ApplicationId", (Object)this.applicationId()).add("CampaignHook", (Object)this.campaignHook()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Limits", (Object)this.limits()).add("QuietTime", (Object)this.quietTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "CampaignHook": {
                return Optional.ofNullable(clazz.cast(this.campaignHook()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "Limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
            case "QuietTime": {
                return Optional.ofNullable(clazz.cast(this.quietTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSettingsResource, T> g) {
        return obj -> g.apply((ApplicationSettingsResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private CampaignHook campaignHook;
        private String lastModifiedDate;
        private CampaignLimits limits;
        private QuietTime quietTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSettingsResource model) {
            this.applicationId(model.applicationId);
            this.campaignHook(model.campaignHook);
            this.lastModifiedDate(model.lastModifiedDate);
            this.limits(model.limits);
            this.quietTime(model.quietTime);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final CampaignHook.Builder getCampaignHook() {
            return this.campaignHook != null ? this.campaignHook.toBuilder() : null;
        }

        public final void setCampaignHook(CampaignHook.BuilderImpl campaignHook) {
            this.campaignHook = campaignHook != null ? campaignHook.build() : null;
        }

        @Override
        public final Builder campaignHook(CampaignHook campaignHook) {
            this.campaignHook = campaignHook;
            return this;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final CampaignLimits.Builder getLimits() {
            return this.limits != null ? this.limits.toBuilder() : null;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final QuietTime.Builder getQuietTime() {
            return this.quietTime != null ? this.quietTime.toBuilder() : null;
        }

        public final void setQuietTime(QuietTime.BuilderImpl quietTime) {
            this.quietTime = quietTime != null ? quietTime.build() : null;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public ApplicationSettingsResource build() {
            return new ApplicationSettingsResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationSettingsResource> {
        public Builder applicationId(String var1);

        public Builder campaignHook(CampaignHook var1);

        default public Builder campaignHook(Consumer<CampaignHook.Builder> campaignHook) {
            return this.campaignHook((CampaignHook)((CampaignHook.Builder)CampaignHook.builder().applyMutation(campaignHook)).build());
        }

        public Builder lastModifiedDate(String var1);

        public Builder limits(CampaignLimits var1);

        default public Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return this.limits((CampaignLimits)((CampaignLimits.Builder)CampaignLimits.builder().applyMutation(limits)).build());
        }

        public Builder quietTime(QuietTime var1);

        default public Builder quietTime(Consumer<QuietTime.Builder> quietTime) {
            return this.quietTime((QuietTime)((QuietTime.Builder)QuietTime.builder().applyMutation(quietTime)).build());
        }
    }
}

