/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TemplateType {
    EMAIL("EMAIL"),
    SMS("SMS"),
    VOICE("VOICE"),
    PUSH("PUSH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TemplateType> VALUE_MAP;
    private final String value;

    private TemplateType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TemplateType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TemplateType> knownValues() {
        EnumSet<TemplateType> knownValues = EnumSet.allOf(TemplateType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TemplateType.class, TemplateType::toString);
    }
}

