/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.Format;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportJobRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportJobRequest> {
    private static final SdkField<Boolean> DEFINE_SEGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DefineSegment").getter(ImportJobRequest.getter(ImportJobRequest::defineSegment)).setter(ImportJobRequest.setter(Builder::defineSegment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefineSegment").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalId").getter(ImportJobRequest.getter(ImportJobRequest::externalId)).setter(ImportJobRequest.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(ImportJobRequest.getter(ImportJobRequest::formatAsString)).setter(ImportJobRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<Boolean> REGISTER_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RegisterEndpoints").getter(ImportJobRequest.getter(ImportJobRequest::registerEndpoints)).setter(ImportJobRequest.setter(Builder::registerEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisterEndpoints").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(ImportJobRequest.getter(ImportJobRequest::roleArn)).setter(ImportJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> S3_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Url").getter(ImportJobRequest.getter(ImportJobRequest::s3Url)).setter(ImportJobRequest.setter(Builder::s3Url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Url").build()}).build();
    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentId").getter(ImportJobRequest.getter(ImportJobRequest::segmentId)).setter(ImportJobRequest.setter(Builder::segmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()}).build();
    private static final SdkField<String> SEGMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentName").getter(ImportJobRequest.getter(ImportJobRequest::segmentName)).setter(ImportJobRequest.setter(Builder::segmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINE_SEGMENT_FIELD, EXTERNAL_ID_FIELD, FORMAT_FIELD, REGISTER_ENDPOINTS_FIELD, ROLE_ARN_FIELD, S3_URL_FIELD, SEGMENT_ID_FIELD, SEGMENT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean defineSegment;
    private final String externalId;
    private final String format;
    private final Boolean registerEndpoints;
    private final String roleArn;
    private final String s3Url;
    private final String segmentId;
    private final String segmentName;

    private ImportJobRequest(BuilderImpl builder) {
        this.defineSegment = builder.defineSegment;
        this.externalId = builder.externalId;
        this.format = builder.format;
        this.registerEndpoints = builder.registerEndpoints;
        this.roleArn = builder.roleArn;
        this.s3Url = builder.s3Url;
        this.segmentId = builder.segmentId;
        this.segmentName = builder.segmentName;
    }

    public final Boolean defineSegment() {
        return this.defineSegment;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final Format format() {
        return Format.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final Boolean registerEndpoints() {
        return this.registerEndpoints;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String s3Url() {
        return this.s3Url;
    }

    public final String segmentId() {
        return this.segmentId;
    }

    public final String segmentName() {
        return this.segmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defineSegment());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.registerEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Url());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportJobRequest)) {
            return false;
        }
        ImportJobRequest other = (ImportJobRequest)obj;
        return Objects.equals(this.defineSegment(), other.defineSegment()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.registerEndpoints(), other.registerEndpoints()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.s3Url(), other.s3Url()) && Objects.equals(this.segmentId(), other.segmentId()) && Objects.equals(this.segmentName(), other.segmentName());
    }

    public final String toString() {
        return ToString.builder((String)"ImportJobRequest").add("DefineSegment", (Object)this.defineSegment()).add("ExternalId", (Object)this.externalId()).add("Format", (Object)this.formatAsString()).add("RegisterEndpoints", (Object)this.registerEndpoints()).add("RoleArn", (Object)this.roleArn()).add("S3Url", (Object)this.s3Url()).add("SegmentId", (Object)this.segmentId()).add("SegmentName", (Object)this.segmentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefineSegment": {
                return Optional.ofNullable(clazz.cast(this.defineSegment()));
            }
            case "ExternalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "RegisterEndpoints": {
                return Optional.ofNullable(clazz.cast(this.registerEndpoints()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "S3Url": {
                return Optional.ofNullable(clazz.cast(this.s3Url()));
            }
            case "SegmentId": {
                return Optional.ofNullable(clazz.cast(this.segmentId()));
            }
            case "SegmentName": {
                return Optional.ofNullable(clazz.cast(this.segmentName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportJobRequest, T> g) {
        return obj -> g.apply((ImportJobRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean defineSegment;
        private String externalId;
        private String format;
        private Boolean registerEndpoints;
        private String roleArn;
        private String s3Url;
        private String segmentId;
        private String segmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportJobRequest model) {
            this.defineSegment(model.defineSegment);
            this.externalId(model.externalId);
            this.format(model.format);
            this.registerEndpoints(model.registerEndpoints);
            this.roleArn(model.roleArn);
            this.s3Url(model.s3Url);
            this.segmentId(model.segmentId);
            this.segmentName(model.segmentName);
        }

        public final Boolean getDefineSegment() {
            return this.defineSegment;
        }

        public final void setDefineSegment(Boolean defineSegment) {
            this.defineSegment = defineSegment;
        }

        @Override
        @Transient
        public final Builder defineSegment(Boolean defineSegment) {
            this.defineSegment = defineSegment;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        @Transient
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        @Transient
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        @Transient
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Boolean getRegisterEndpoints() {
            return this.registerEndpoints;
        }

        public final void setRegisterEndpoints(Boolean registerEndpoints) {
            this.registerEndpoints = registerEndpoints;
        }

        @Override
        @Transient
        public final Builder registerEndpoints(Boolean registerEndpoints) {
            this.registerEndpoints = registerEndpoints;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getS3Url() {
            return this.s3Url;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        @Override
        @Transient
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        @Override
        @Transient
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final String getSegmentName() {
            return this.segmentName;
        }

        public final void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        @Override
        @Transient
        public final Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        public ImportJobRequest build() {
            return new ImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportJobRequest> {
        public Builder defineSegment(Boolean var1);

        public Builder externalId(String var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder registerEndpoints(Boolean var1);

        public Builder roleArn(String var1);

        public Builder s3Url(String var1);

        public Builder segmentId(String var1);

        public Builder segmentName(String var1);
    }
}

