/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.SMSChannelRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSmsChannelRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateSmsChannelRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(UpdateSmsChannelRequest.getter(UpdateSmsChannelRequest::applicationId)).setter(UpdateSmsChannelRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<SMSChannelRequest> SMS_CHANNEL_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SMSChannelRequest").getter(UpdateSmsChannelRequest.getter(UpdateSmsChannelRequest::smsChannelRequest)).setter(UpdateSmsChannelRequest.setter(Builder::smsChannelRequest)).constructor(SMSChannelRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSChannelRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, SMS_CHANNEL_REQUEST_FIELD));
    private final String applicationId;
    private final SMSChannelRequest smsChannelRequest;

    private UpdateSmsChannelRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.smsChannelRequest = builder.smsChannelRequest;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final SMSChannelRequest smsChannelRequest() {
        return this.smsChannelRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsChannelRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSmsChannelRequest)) {
            return false;
        }
        UpdateSmsChannelRequest other = (UpdateSmsChannelRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.smsChannelRequest(), other.smsChannelRequest());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSmsChannelRequest").add("ApplicationId", (Object)this.applicationId()).add("SMSChannelRequest", (Object)this.smsChannelRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "SMSChannelRequest": {
                return Optional.ofNullable(clazz.cast(this.smsChannelRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSmsChannelRequest, T> g) {
        return obj -> g.apply((UpdateSmsChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private SMSChannelRequest smsChannelRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSmsChannelRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.smsChannelRequest(model.smsChannelRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final SMSChannelRequest.Builder getSmsChannelRequest() {
            return this.smsChannelRequest != null ? this.smsChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder smsChannelRequest(SMSChannelRequest smsChannelRequest) {
            this.smsChannelRequest = smsChannelRequest;
            return this;
        }

        public final void setSmsChannelRequest(SMSChannelRequest.BuilderImpl smsChannelRequest) {
            this.smsChannelRequest = smsChannelRequest != null ? smsChannelRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSmsChannelRequest build() {
            return new UpdateSmsChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSmsChannelRequest> {
        public Builder applicationId(String var1);

        public Builder smsChannelRequest(SMSChannelRequest var1);

        default public Builder smsChannelRequest(Consumer<SMSChannelRequest.Builder> smsChannelRequest) {
            return this.smsChannelRequest((SMSChannelRequest)((SMSChannelRequest.Builder)SMSChannelRequest.builder().applyMutation(smsChannelRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

