/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.ImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImportJobRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, CreateImportJobRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(CreateImportJobRequest.getter(CreateImportJobRequest::applicationId)).setter(CreateImportJobRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<ImportJobRequest> IMPORT_JOB_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportJobRequest").getter(CreateImportJobRequest.getter(CreateImportJobRequest::importJobRequest)).setter(CreateImportJobRequest.setter(Builder::importJobRequest)).constructor(ImportJobRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, IMPORT_JOB_REQUEST_FIELD));
    private final String applicationId;
    private final ImportJobRequest importJobRequest;

    private CreateImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.importJobRequest = builder.importJobRequest;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final ImportJobRequest importJobRequest() {
        return this.importJobRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importJobRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImportJobRequest)) {
            return false;
        }
        CreateImportJobRequest other = (CreateImportJobRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.importJobRequest(), other.importJobRequest());
    }

    public final String toString() {
        return ToString.builder((String)"CreateImportJobRequest").add("ApplicationId", (Object)this.applicationId()).add("ImportJobRequest", (Object)this.importJobRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ImportJobRequest": {
                return Optional.ofNullable(clazz.cast(this.importJobRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateImportJobRequest, T> g) {
        return obj -> g.apply((CreateImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private ImportJobRequest importJobRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImportJobRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.importJobRequest(model.importJobRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final ImportJobRequest.Builder getImportJobRequest() {
            return this.importJobRequest != null ? this.importJobRequest.toBuilder() : null;
        }

        public final void setImportJobRequest(ImportJobRequest.BuilderImpl importJobRequest) {
            this.importJobRequest = importJobRequest != null ? importJobRequest.build() : null;
        }

        @Override
        @Transient
        public final Builder importJobRequest(ImportJobRequest importJobRequest) {
            this.importJobRequest = importJobRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImportJobRequest build() {
            return new CreateImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImportJobRequest> {
        public Builder applicationId(String var1);

        public Builder importJobRequest(ImportJobRequest var1);

        default public Builder importJobRequest(Consumer<ImportJobRequest.Builder> importJobRequest) {
            return this.importJobRequest((ImportJobRequest)((ImportJobRequest.Builder)ImportJobRequest.builder().applyMutation(importJobRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

