/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.APNSPushNotificationTemplate;
import software.amazon.awssdk.services.pinpoint.model.AndroidPushNotificationTemplate;
import software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationTemplate;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.TemplateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PushNotificationTemplateResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PushNotificationTemplateResponse> {
    private static final SdkField<AndroidPushNotificationTemplate> ADM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ADM").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::adm)).setter(PushNotificationTemplateResponse.setter(Builder::adm)).constructor(AndroidPushNotificationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ADM").build()}).build();
    private static final SdkField<APNSPushNotificationTemplate> APNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("APNS").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::apns)).setter(PushNotificationTemplateResponse.setter(Builder::apns)).constructor(APNSPushNotificationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNS").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::arn)).setter(PushNotificationTemplateResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<AndroidPushNotificationTemplate> BAIDU_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Baidu").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::baidu)).setter(PushNotificationTemplateResponse.setter(Builder::baidu)).constructor(AndroidPushNotificationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Baidu").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::creationDate)).setter(PushNotificationTemplateResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<DefaultPushNotificationTemplate> DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Default").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::defaultValue)).setter(PushNotificationTemplateResponse.setter(Builder::defaultValue)).constructor(DefaultPushNotificationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Default").build()}).build();
    private static final SdkField<String> DEFAULT_SUBSTITUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultSubstitutions").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::defaultSubstitutions)).setter(PushNotificationTemplateResponse.setter(Builder::defaultSubstitutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubstitutions").build()}).build();
    private static final SdkField<AndroidPushNotificationTemplate> GCM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GCM").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::gcm)).setter(PushNotificationTemplateResponse.setter(Builder::gcm)).constructor(AndroidPushNotificationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GCM").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedDate").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::lastModifiedDate)).setter(PushNotificationTemplateResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> RECOMMENDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommenderId").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::recommenderId)).setter(PushNotificationTemplateResponse.setter(Builder::recommenderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::tags)).setter(PushNotificationTemplateResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateDescription").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::templateDescription)).setter(PushNotificationTemplateResponse.setter(Builder::templateDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::templateName)).setter(PushNotificationTemplateResponse.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateType").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::templateTypeAsString)).setter(PushNotificationTemplateResponse.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(PushNotificationTemplateResponse.getter(PushNotificationTemplateResponse::version)).setter(PushNotificationTemplateResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADM_FIELD, APNS_FIELD, ARN_FIELD, BAIDU_FIELD, CREATION_DATE_FIELD, DEFAULT_FIELD, DEFAULT_SUBSTITUTIONS_FIELD, GCM_FIELD, LAST_MODIFIED_DATE_FIELD, RECOMMENDER_ID_FIELD, TAGS_FIELD, TEMPLATE_DESCRIPTION_FIELD, TEMPLATE_NAME_FIELD, TEMPLATE_TYPE_FIELD, VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final AndroidPushNotificationTemplate adm;
    private final APNSPushNotificationTemplate apns;
    private final String arn;
    private final AndroidPushNotificationTemplate baidu;
    private final String creationDate;
    private final DefaultPushNotificationTemplate defaultValue;
    private final String defaultSubstitutions;
    private final AndroidPushNotificationTemplate gcm;
    private final String lastModifiedDate;
    private final String recommenderId;
    private final Map<String, String> tags;
    private final String templateDescription;
    private final String templateName;
    private final String templateType;
    private final String version;

    private PushNotificationTemplateResponse(BuilderImpl builder) {
        this.adm = builder.adm;
        this.apns = builder.apns;
        this.arn = builder.arn;
        this.baidu = builder.baidu;
        this.creationDate = builder.creationDate;
        this.defaultValue = builder.defaultValue;
        this.defaultSubstitutions = builder.defaultSubstitutions;
        this.gcm = builder.gcm;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.recommenderId = builder.recommenderId;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
        this.templateName = builder.templateName;
        this.templateType = builder.templateType;
        this.version = builder.version;
    }

    public final AndroidPushNotificationTemplate adm() {
        return this.adm;
    }

    public final APNSPushNotificationTemplate apns() {
        return this.apns;
    }

    public final String arn() {
        return this.arn;
    }

    public final AndroidPushNotificationTemplate baidu() {
        return this.baidu;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final DefaultPushNotificationTemplate defaultValue() {
        return this.defaultValue;
    }

    public final String defaultSubstitutions() {
        return this.defaultSubstitutions;
    }

    public final AndroidPushNotificationTemplate gcm() {
        return this.gcm;
    }

    public final String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String recommenderId() {
        return this.recommenderId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String templateDescription() {
        return this.templateDescription;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final TemplateType templateType() {
        return TemplateType.fromValue(this.templateType);
    }

    public final String templateTypeAsString() {
        return this.templateType;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adm());
        hashCode = 31 * hashCode + Objects.hashCode(this.apns());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.baidu());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSubstitutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.gcm());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushNotificationTemplateResponse)) {
            return false;
        }
        PushNotificationTemplateResponse other = (PushNotificationTemplateResponse)obj;
        return Objects.equals(this.adm(), other.adm()) && Objects.equals(this.apns(), other.apns()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.baidu(), other.baidu()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.defaultSubstitutions(), other.defaultSubstitutions()) && Objects.equals(this.gcm(), other.gcm()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.recommenderId(), other.recommenderId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateDescription(), other.templateDescription()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateTypeAsString(), other.templateTypeAsString()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"PushNotificationTemplateResponse").add("ADM", (Object)this.adm()).add("APNS", (Object)this.apns()).add("Arn", (Object)this.arn()).add("Baidu", (Object)this.baidu()).add("CreationDate", (Object)this.creationDate()).add("Default", (Object)this.defaultValue()).add("DefaultSubstitutions", (Object)this.defaultSubstitutions()).add("GCM", (Object)this.gcm()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("RecommenderId", (Object)this.recommenderId()).add("Tags", this.hasTags() ? this.tags() : null).add("TemplateDescription", (Object)this.templateDescription()).add("TemplateName", (Object)this.templateName()).add("TemplateType", (Object)this.templateTypeAsString()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ADM": {
                return Optional.ofNullable(clazz.cast(this.adm()));
            }
            case "APNS": {
                return Optional.ofNullable(clazz.cast(this.apns()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Baidu": {
                return Optional.ofNullable(clazz.cast(this.baidu()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Default": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "DefaultSubstitutions": {
                return Optional.ofNullable(clazz.cast(this.defaultSubstitutions()));
            }
            case "GCM": {
                return Optional.ofNullable(clazz.cast(this.gcm()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "RecommenderId": {
                return Optional.ofNullable(clazz.cast(this.recommenderId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TemplateDescription": {
                return Optional.ofNullable(clazz.cast(this.templateDescription()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "TemplateType": {
                return Optional.ofNullable(clazz.cast(this.templateTypeAsString()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PushNotificationTemplateResponse, T> g) {
        return obj -> g.apply((PushNotificationTemplateResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AndroidPushNotificationTemplate adm;
        private APNSPushNotificationTemplate apns;
        private String arn;
        private AndroidPushNotificationTemplate baidu;
        private String creationDate;
        private DefaultPushNotificationTemplate defaultValue;
        private String defaultSubstitutions;
        private AndroidPushNotificationTemplate gcm;
        private String lastModifiedDate;
        private String recommenderId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String templateDescription;
        private String templateName;
        private String templateType;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(PushNotificationTemplateResponse model) {
            this.adm(model.adm);
            this.apns(model.apns);
            this.arn(model.arn);
            this.baidu(model.baidu);
            this.creationDate(model.creationDate);
            this.defaultValue(model.defaultValue);
            this.defaultSubstitutions(model.defaultSubstitutions);
            this.gcm(model.gcm);
            this.lastModifiedDate(model.lastModifiedDate);
            this.recommenderId(model.recommenderId);
            this.tags(model.tags);
            this.templateDescription(model.templateDescription);
            this.templateName(model.templateName);
            this.templateType(model.templateType);
            this.version(model.version);
        }

        public final AndroidPushNotificationTemplate.Builder getAdm() {
            return this.adm != null ? this.adm.toBuilder() : null;
        }

        public final void setAdm(AndroidPushNotificationTemplate.BuilderImpl adm) {
            this.adm = adm != null ? adm.build() : null;
        }

        @Override
        @Transient
        public final Builder adm(AndroidPushNotificationTemplate adm) {
            this.adm = adm;
            return this;
        }

        public final APNSPushNotificationTemplate.Builder getApns() {
            return this.apns != null ? this.apns.toBuilder() : null;
        }

        public final void setApns(APNSPushNotificationTemplate.BuilderImpl apns) {
            this.apns = apns != null ? apns.build() : null;
        }

        @Override
        @Transient
        public final Builder apns(APNSPushNotificationTemplate apns) {
            this.apns = apns;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final AndroidPushNotificationTemplate.Builder getBaidu() {
            return this.baidu != null ? this.baidu.toBuilder() : null;
        }

        public final void setBaidu(AndroidPushNotificationTemplate.BuilderImpl baidu) {
            this.baidu = baidu != null ? baidu.build() : null;
        }

        @Override
        @Transient
        public final Builder baidu(AndroidPushNotificationTemplate baidu) {
            this.baidu = baidu;
            return this;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final DefaultPushNotificationTemplate.Builder getDefaultValue() {
            return this.defaultValue != null ? this.defaultValue.toBuilder() : null;
        }

        public final void setDefaultValue(DefaultPushNotificationTemplate.BuilderImpl defaultValue) {
            this.defaultValue = defaultValue != null ? defaultValue.build() : null;
        }

        @Override
        @Transient
        public final Builder defaultValue(DefaultPushNotificationTemplate defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getDefaultSubstitutions() {
            return this.defaultSubstitutions;
        }

        public final void setDefaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
        }

        @Override
        @Transient
        public final Builder defaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        public final AndroidPushNotificationTemplate.Builder getGcm() {
            return this.gcm != null ? this.gcm.toBuilder() : null;
        }

        public final void setGcm(AndroidPushNotificationTemplate.BuilderImpl gcm) {
            this.gcm = gcm != null ? gcm.build() : null;
        }

        @Override
        @Transient
        public final Builder gcm(AndroidPushNotificationTemplate gcm) {
            this.gcm = gcm;
            return this;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        @Transient
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getRecommenderId() {
            return this.recommenderId;
        }

        public final void setRecommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
        }

        @Override
        @Transient
        public final Builder recommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTemplateDescription() {
            return this.templateDescription;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        @Override
        @Transient
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        @Transient
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        @Transient
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        @Transient
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public PushNotificationTemplateResponse build() {
            return new PushNotificationTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PushNotificationTemplateResponse> {
        public Builder adm(AndroidPushNotificationTemplate var1);

        default public Builder adm(Consumer<AndroidPushNotificationTemplate.Builder> adm) {
            return this.adm((AndroidPushNotificationTemplate)((AndroidPushNotificationTemplate.Builder)AndroidPushNotificationTemplate.builder().applyMutation(adm)).build());
        }

        public Builder apns(APNSPushNotificationTemplate var1);

        default public Builder apns(Consumer<APNSPushNotificationTemplate.Builder> apns) {
            return this.apns((APNSPushNotificationTemplate)((APNSPushNotificationTemplate.Builder)APNSPushNotificationTemplate.builder().applyMutation(apns)).build());
        }

        public Builder arn(String var1);

        public Builder baidu(AndroidPushNotificationTemplate var1);

        default public Builder baidu(Consumer<AndroidPushNotificationTemplate.Builder> baidu) {
            return this.baidu((AndroidPushNotificationTemplate)((AndroidPushNotificationTemplate.Builder)AndroidPushNotificationTemplate.builder().applyMutation(baidu)).build());
        }

        public Builder creationDate(String var1);

        public Builder defaultValue(DefaultPushNotificationTemplate var1);

        default public Builder defaultValue(Consumer<DefaultPushNotificationTemplate.Builder> defaultValue) {
            return this.defaultValue((DefaultPushNotificationTemplate)((DefaultPushNotificationTemplate.Builder)DefaultPushNotificationTemplate.builder().applyMutation(defaultValue)).build());
        }

        public Builder defaultSubstitutions(String var1);

        public Builder gcm(AndroidPushNotificationTemplate var1);

        default public Builder gcm(Consumer<AndroidPushNotificationTemplate.Builder> gcm) {
            return this.gcm((AndroidPushNotificationTemplate)((AndroidPushNotificationTemplate.Builder)AndroidPushNotificationTemplate.builder().applyMutation(gcm)).build());
        }

        public Builder lastModifiedDate(String var1);

        public Builder recommenderId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder templateDescription(String var1);

        public Builder templateName(String var1);

        public Builder templateType(String var1);

        public Builder templateType(TemplateType var1);

        public Builder version(String var1);
    }
}

