/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.CampaignHook;
import software.amazon.awssdk.services.pinpoint.model.CampaignLimits;
import software.amazon.awssdk.services.pinpoint.model.CampaignState;
import software.amazon.awssdk.services.pinpoint.model.CustomDeliveryConfiguration;
import software.amazon.awssdk.services.pinpoint.model.ListOfTreatmentResourceCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.Schedule;
import software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration;
import software.amazon.awssdk.services.pinpoint.model.TreatmentResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CampaignResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CampaignResponse> {
    private static final SdkField<List<TreatmentResource>> ADDITIONAL_TREATMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalTreatments").getter(CampaignResponse.getter(CampaignResponse::additionalTreatments)).setter(CampaignResponse.setter(Builder::additionalTreatments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalTreatments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TreatmentResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(CampaignResponse.getter(CampaignResponse::applicationId)).setter(CampaignResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CampaignResponse.getter(CampaignResponse::arn)).setter(CampaignResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(CampaignResponse.getter(CampaignResponse::creationDate)).setter(CampaignResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<CustomDeliveryConfiguration> CUSTOM_DELIVERY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomDeliveryConfiguration").getter(CampaignResponse.getter(CampaignResponse::customDeliveryConfiguration)).setter(CampaignResponse.setter(Builder::customDeliveryConfiguration)).constructor(CustomDeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDeliveryConfiguration").build()}).build();
    private static final SdkField<CampaignState> DEFAULT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultState").getter(CampaignResponse.getter(CampaignResponse::defaultState)).setter(CampaignResponse.setter(Builder::defaultState)).constructor(CampaignState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultState").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CampaignResponse.getter(CampaignResponse::description)).setter(CampaignResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> HOLDOUT_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HoldoutPercent").getter(CampaignResponse.getter(CampaignResponse::holdoutPercent)).setter(CampaignResponse.setter(Builder::holdoutPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoldoutPercent").build()}).build();
    private static final SdkField<CampaignHook> HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Hook").getter(CampaignResponse.getter(CampaignResponse::hook)).setter(CampaignResponse.setter(Builder::hook)).constructor(CampaignHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hook").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CampaignResponse.getter(CampaignResponse::id)).setter(CampaignResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Boolean> IS_PAUSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsPaused").getter(CampaignResponse.getter(CampaignResponse::isPaused)).setter(CampaignResponse.setter(Builder::isPaused)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPaused").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedDate").getter(CampaignResponse.getter(CampaignResponse::lastModifiedDate)).setter(CampaignResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<CampaignLimits> LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Limits").getter(CampaignResponse.getter(CampaignResponse::limits)).setter(CampaignResponse.setter(Builder::limits)).constructor(CampaignLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build()}).build();
    private static final SdkField<MessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MessageConfiguration").getter(CampaignResponse.getter(CampaignResponse::messageConfiguration)).setter(CampaignResponse.setter(Builder::messageConfiguration)).constructor(MessageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CampaignResponse.getter(CampaignResponse::name)).setter(CampaignResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schedule").getter(CampaignResponse.getter(CampaignResponse::schedule)).setter(CampaignResponse.setter(Builder::schedule)).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentId").getter(CampaignResponse.getter(CampaignResponse::segmentId)).setter(CampaignResponse.setter(Builder::segmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()}).build();
    private static final SdkField<Integer> SEGMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentVersion").getter(CampaignResponse.getter(CampaignResponse::segmentVersion)).setter(CampaignResponse.setter(Builder::segmentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentVersion").build()}).build();
    private static final SdkField<CampaignState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("State").getter(CampaignResponse.getter(CampaignResponse::state)).setter(CampaignResponse.setter(Builder::state)).constructor(CampaignState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CampaignResponse.getter(CampaignResponse::tags)).setter(CampaignResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplateConfiguration").getter(CampaignResponse.getter(CampaignResponse::templateConfiguration)).setter(CampaignResponse.setter(Builder::templateConfiguration)).constructor(TemplateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build()}).build();
    private static final SdkField<String> TREATMENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreatmentDescription").getter(CampaignResponse.getter(CampaignResponse::treatmentDescription)).setter(CampaignResponse.setter(Builder::treatmentDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentDescription").build()}).build();
    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreatmentName").getter(CampaignResponse.getter(CampaignResponse::treatmentName)).setter(CampaignResponse.setter(Builder::treatmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentName").build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Version").getter(CampaignResponse.getter(CampaignResponse::version)).setter(CampaignResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_TREATMENTS_FIELD, APPLICATION_ID_FIELD, ARN_FIELD, CREATION_DATE_FIELD, CUSTOM_DELIVERY_CONFIGURATION_FIELD, DEFAULT_STATE_FIELD, DESCRIPTION_FIELD, HOLDOUT_PERCENT_FIELD, HOOK_FIELD, ID_FIELD, IS_PAUSED_FIELD, LAST_MODIFIED_DATE_FIELD, LIMITS_FIELD, MESSAGE_CONFIGURATION_FIELD, NAME_FIELD, SCHEDULE_FIELD, SEGMENT_ID_FIELD, SEGMENT_VERSION_FIELD, STATE_FIELD, TAGS_FIELD, TEMPLATE_CONFIGURATION_FIELD, TREATMENT_DESCRIPTION_FIELD, TREATMENT_NAME_FIELD, VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<TreatmentResource> additionalTreatments;
    private final String applicationId;
    private final String arn;
    private final String creationDate;
    private final CustomDeliveryConfiguration customDeliveryConfiguration;
    private final CampaignState defaultState;
    private final String description;
    private final Integer holdoutPercent;
    private final CampaignHook hook;
    private final String id;
    private final Boolean isPaused;
    private final String lastModifiedDate;
    private final CampaignLimits limits;
    private final MessageConfiguration messageConfiguration;
    private final String name;
    private final Schedule schedule;
    private final String segmentId;
    private final Integer segmentVersion;
    private final CampaignState state;
    private final Map<String, String> tags;
    private final TemplateConfiguration templateConfiguration;
    private final String treatmentDescription;
    private final String treatmentName;
    private final Integer version;

    private CampaignResponse(BuilderImpl builder) {
        this.additionalTreatments = builder.additionalTreatments;
        this.applicationId = builder.applicationId;
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.customDeliveryConfiguration = builder.customDeliveryConfiguration;
        this.defaultState = builder.defaultState;
        this.description = builder.description;
        this.holdoutPercent = builder.holdoutPercent;
        this.hook = builder.hook;
        this.id = builder.id;
        this.isPaused = builder.isPaused;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.limits = builder.limits;
        this.messageConfiguration = builder.messageConfiguration;
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
        this.state = builder.state;
        this.tags = builder.tags;
        this.templateConfiguration = builder.templateConfiguration;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
        this.version = builder.version;
    }

    public final boolean hasAdditionalTreatments() {
        return this.additionalTreatments != null && !(this.additionalTreatments instanceof SdkAutoConstructList);
    }

    public final List<TreatmentResource> additionalTreatments() {
        return this.additionalTreatments;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final CustomDeliveryConfiguration customDeliveryConfiguration() {
        return this.customDeliveryConfiguration;
    }

    public final CampaignState defaultState() {
        return this.defaultState;
    }

    public final String description() {
        return this.description;
    }

    public final Integer holdoutPercent() {
        return this.holdoutPercent;
    }

    public final CampaignHook hook() {
        return this.hook;
    }

    public final String id() {
        return this.id;
    }

    public final Boolean isPaused() {
        return this.isPaused;
    }

    public final String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final CampaignLimits limits() {
        return this.limits;
    }

    public final MessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final Schedule schedule() {
        return this.schedule;
    }

    public final String segmentId() {
        return this.segmentId;
    }

    public final Integer segmentVersion() {
        return this.segmentVersion;
    }

    public final CampaignState state() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final TemplateConfiguration templateConfiguration() {
        return this.templateConfiguration;
    }

    public final String treatmentDescription() {
        return this.treatmentDescription;
    }

    public final String treatmentName() {
        return this.treatmentName;
    }

    public final Integer version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalTreatments() ? this.additionalTreatments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultState());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.holdoutPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hook());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPaused());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.limits());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignResponse)) {
            return false;
        }
        CampaignResponse other = (CampaignResponse)obj;
        return this.hasAdditionalTreatments() == other.hasAdditionalTreatments() && Objects.equals(this.additionalTreatments(), other.additionalTreatments()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.customDeliveryConfiguration(), other.customDeliveryConfiguration()) && Objects.equals(this.defaultState(), other.defaultState()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.holdoutPercent(), other.holdoutPercent()) && Objects.equals(this.hook(), other.hook()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.isPaused(), other.isPaused()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.limits(), other.limits()) && Objects.equals(this.messageConfiguration(), other.messageConfiguration()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.segmentId(), other.segmentId()) && Objects.equals(this.segmentVersion(), other.segmentVersion()) && Objects.equals(this.state(), other.state()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateConfiguration(), other.templateConfiguration()) && Objects.equals(this.treatmentDescription(), other.treatmentDescription()) && Objects.equals(this.treatmentName(), other.treatmentName()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"CampaignResponse").add("AdditionalTreatments", this.hasAdditionalTreatments() ? this.additionalTreatments() : null).add("ApplicationId", (Object)this.applicationId()).add("Arn", (Object)this.arn()).add("CreationDate", (Object)this.creationDate()).add("CustomDeliveryConfiguration", (Object)this.customDeliveryConfiguration()).add("DefaultState", (Object)this.defaultState()).add("Description", (Object)this.description()).add("HoldoutPercent", (Object)this.holdoutPercent()).add("Hook", (Object)this.hook()).add("Id", (Object)this.id()).add("IsPaused", (Object)this.isPaused()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Limits", (Object)this.limits()).add("MessageConfiguration", (Object)this.messageConfiguration()).add("Name", (Object)this.name()).add("Schedule", (Object)this.schedule()).add("SegmentId", (Object)this.segmentId()).add("SegmentVersion", (Object)this.segmentVersion()).add("State", (Object)this.state()).add("Tags", this.hasTags() ? this.tags() : null).add("TemplateConfiguration", (Object)this.templateConfiguration()).add("TreatmentDescription", (Object)this.treatmentDescription()).add("TreatmentName", (Object)this.treatmentName()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalTreatments": {
                return Optional.ofNullable(clazz.cast(this.additionalTreatments()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CustomDeliveryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customDeliveryConfiguration()));
            }
            case "DefaultState": {
                return Optional.ofNullable(clazz.cast(this.defaultState()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HoldoutPercent": {
                return Optional.ofNullable(clazz.cast(this.holdoutPercent()));
            }
            case "Hook": {
                return Optional.ofNullable(clazz.cast(this.hook()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IsPaused": {
                return Optional.ofNullable(clazz.cast(this.isPaused()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "Limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
            case "MessageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.messageConfiguration()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "SegmentId": {
                return Optional.ofNullable(clazz.cast(this.segmentId()));
            }
            case "SegmentVersion": {
                return Optional.ofNullable(clazz.cast(this.segmentVersion()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TemplateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.templateConfiguration()));
            }
            case "TreatmentDescription": {
                return Optional.ofNullable(clazz.cast(this.treatmentDescription()));
            }
            case "TreatmentName": {
                return Optional.ofNullable(clazz.cast(this.treatmentName()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignResponse, T> g) {
        return obj -> g.apply((CampaignResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TreatmentResource> additionalTreatments = DefaultSdkAutoConstructList.getInstance();
        private String applicationId;
        private String arn;
        private String creationDate;
        private CustomDeliveryConfiguration customDeliveryConfiguration;
        private CampaignState defaultState;
        private String description;
        private Integer holdoutPercent;
        private CampaignHook hook;
        private String id;
        private Boolean isPaused;
        private String lastModifiedDate;
        private CampaignLimits limits;
        private MessageConfiguration messageConfiguration;
        private String name;
        private Schedule schedule;
        private String segmentId;
        private Integer segmentVersion;
        private CampaignState state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private TemplateConfiguration templateConfiguration;
        private String treatmentDescription;
        private String treatmentName;
        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignResponse model) {
            this.additionalTreatments(model.additionalTreatments);
            this.applicationId(model.applicationId);
            this.arn(model.arn);
            this.creationDate(model.creationDate);
            this.customDeliveryConfiguration(model.customDeliveryConfiguration);
            this.defaultState(model.defaultState);
            this.description(model.description);
            this.holdoutPercent(model.holdoutPercent);
            this.hook(model.hook);
            this.id(model.id);
            this.isPaused(model.isPaused);
            this.lastModifiedDate(model.lastModifiedDate);
            this.limits(model.limits);
            this.messageConfiguration(model.messageConfiguration);
            this.name(model.name);
            this.schedule(model.schedule);
            this.segmentId(model.segmentId);
            this.segmentVersion(model.segmentVersion);
            this.state(model.state);
            this.tags(model.tags);
            this.templateConfiguration(model.templateConfiguration);
            this.treatmentDescription(model.treatmentDescription);
            this.treatmentName(model.treatmentName);
            this.version(model.version);
        }

        public final List<TreatmentResource.Builder> getAdditionalTreatments() {
            List<TreatmentResource.Builder> result = ListOfTreatmentResourceCopier.copyToBuilder(this.additionalTreatments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder additionalTreatments(Collection<TreatmentResource> additionalTreatments) {
            this.additionalTreatments = ListOfTreatmentResourceCopier.copy(additionalTreatments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(TreatmentResource ... additionalTreatments) {
            this.additionalTreatments(Arrays.asList(additionalTreatments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(Consumer<TreatmentResource.Builder> ... additionalTreatments) {
            this.additionalTreatments(Stream.of(additionalTreatments).map(c -> (TreatmentResource)((TreatmentResource.Builder)TreatmentResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalTreatments(Collection<TreatmentResource.BuilderImpl> additionalTreatments) {
            this.additionalTreatments = ListOfTreatmentResourceCopier.copyFromBuilder(additionalTreatments);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final CustomDeliveryConfiguration.Builder getCustomDeliveryConfiguration() {
            return this.customDeliveryConfiguration != null ? this.customDeliveryConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder customDeliveryConfiguration(CustomDeliveryConfiguration customDeliveryConfiguration) {
            this.customDeliveryConfiguration = customDeliveryConfiguration;
            return this;
        }

        public final void setCustomDeliveryConfiguration(CustomDeliveryConfiguration.BuilderImpl customDeliveryConfiguration) {
            this.customDeliveryConfiguration = customDeliveryConfiguration != null ? customDeliveryConfiguration.build() : null;
        }

        public final CampaignState.Builder getDefaultState() {
            return this.defaultState != null ? this.defaultState.toBuilder() : null;
        }

        @Override
        public final Builder defaultState(CampaignState defaultState) {
            this.defaultState = defaultState;
            return this;
        }

        public final void setDefaultState(CampaignState.BuilderImpl defaultState) {
            this.defaultState = defaultState != null ? defaultState.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getHoldoutPercent() {
            return this.holdoutPercent;
        }

        @Override
        public final Builder holdoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
            return this;
        }

        public final void setHoldoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
        }

        public final CampaignHook.Builder getHook() {
            return this.hook != null ? this.hook.toBuilder() : null;
        }

        @Override
        public final Builder hook(CampaignHook hook) {
            this.hook = hook;
            return this;
        }

        public final void setHook(CampaignHook.BuilderImpl hook) {
            this.hook = hook != null ? hook.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Boolean getIsPaused() {
            return this.isPaused;
        }

        @Override
        public final Builder isPaused(Boolean isPaused) {
            this.isPaused = isPaused;
            return this;
        }

        public final void setIsPaused(Boolean isPaused) {
            this.isPaused = isPaused;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final CampaignLimits.Builder getLimits() {
            return this.limits != null ? this.limits.toBuilder() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return this.messageConfiguration != null ? this.messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final Integer getSegmentVersion() {
            return this.segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        public final CampaignState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        @Override
        public final Builder state(CampaignState state) {
            this.state = state;
            return this;
        }

        public final void setState(CampaignState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return this.templateConfiguration != null ? this.templateConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        public final String getTreatmentDescription() {
            return this.treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        public final String getTreatmentName() {
            return this.treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public CampaignResponse build() {
            return new CampaignResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CampaignResponse> {
        public Builder additionalTreatments(Collection<TreatmentResource> var1);

        public Builder additionalTreatments(TreatmentResource ... var1);

        public Builder additionalTreatments(Consumer<TreatmentResource.Builder> ... var1);

        public Builder applicationId(String var1);

        public Builder arn(String var1);

        public Builder creationDate(String var1);

        public Builder customDeliveryConfiguration(CustomDeliveryConfiguration var1);

        default public Builder customDeliveryConfiguration(Consumer<CustomDeliveryConfiguration.Builder> customDeliveryConfiguration) {
            return this.customDeliveryConfiguration((CustomDeliveryConfiguration)((CustomDeliveryConfiguration.Builder)CustomDeliveryConfiguration.builder().applyMutation(customDeliveryConfiguration)).build());
        }

        public Builder defaultState(CampaignState var1);

        default public Builder defaultState(Consumer<CampaignState.Builder> defaultState) {
            return this.defaultState((CampaignState)((CampaignState.Builder)CampaignState.builder().applyMutation(defaultState)).build());
        }

        public Builder description(String var1);

        public Builder holdoutPercent(Integer var1);

        public Builder hook(CampaignHook var1);

        default public Builder hook(Consumer<CampaignHook.Builder> hook) {
            return this.hook((CampaignHook)((CampaignHook.Builder)CampaignHook.builder().applyMutation(hook)).build());
        }

        public Builder id(String var1);

        public Builder isPaused(Boolean var1);

        public Builder lastModifiedDate(String var1);

        public Builder limits(CampaignLimits var1);

        default public Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return this.limits((CampaignLimits)((CampaignLimits.Builder)CampaignLimits.builder().applyMutation(limits)).build());
        }

        public Builder messageConfiguration(MessageConfiguration var1);

        default public Builder messageConfiguration(Consumer<MessageConfiguration.Builder> messageConfiguration) {
            return this.messageConfiguration((MessageConfiguration)((MessageConfiguration.Builder)MessageConfiguration.builder().applyMutation(messageConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder segmentId(String var1);

        public Builder segmentVersion(Integer var1);

        public Builder state(CampaignState var1);

        default public Builder state(Consumer<CampaignState.Builder> state) {
            return this.state((CampaignState)((CampaignState.Builder)CampaignState.builder().applyMutation(state)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder templateConfiguration(TemplateConfiguration var1);

        default public Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return this.templateConfiguration((TemplateConfiguration)((TemplateConfiguration.Builder)TemplateConfiguration.builder().applyMutation(templateConfiguration)).build());
        }

        public Builder treatmentDescription(String var1);

        public Builder treatmentName(String var1);

        public Builder version(Integer var1);
    }
}

