/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.Include;
import software.amazon.awssdk.services.pinpoint.model.ListOfSegmentGroupCopier;
import software.amazon.awssdk.services.pinpoint.model.SegmentGroup;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentGroupList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SegmentGroupList> {
    private static final SdkField<List<SegmentGroup>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(SegmentGroupList.getter(SegmentGroupList::groups)).setter(SegmentGroupList.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Include").getter(SegmentGroupList.getter(SegmentGroupList::includeAsString)).setter(SegmentGroupList.setter(Builder::include)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Include").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPS_FIELD, INCLUDE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<SegmentGroup> groups;
    private final String include;

    private SegmentGroupList(BuilderImpl builder) {
        this.groups = builder.groups;
        this.include = builder.include;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<SegmentGroup> groups() {
        return this.groups;
    }

    public final Include include() {
        return Include.fromValue(this.include);
    }

    public final String includeAsString() {
        return this.include;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentGroupList)) {
            return false;
        }
        SegmentGroupList other = (SegmentGroupList)obj;
        return this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.includeAsString(), other.includeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SegmentGroupList").add("Groups", this.hasGroups() ? this.groups() : null).add("Include", (Object)this.includeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Include": {
                return Optional.ofNullable(clazz.cast(this.includeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentGroupList, T> g) {
        return obj -> g.apply((SegmentGroupList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SegmentGroup> groups = DefaultSdkAutoConstructList.getInstance();
        private String include;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentGroupList model) {
            this.groups(model.groups);
            this.include(model.include);
        }

        public final List<SegmentGroup.Builder> getGroups() {
            List<SegmentGroup.Builder> result = ListOfSegmentGroupCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder groups(Collection<SegmentGroup> groups) {
            this.groups = ListOfSegmentGroupCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(SegmentGroup ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<SegmentGroup.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (SegmentGroup)((SegmentGroup.Builder)SegmentGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<SegmentGroup.BuilderImpl> groups) {
            this.groups = ListOfSegmentGroupCopier.copyFromBuilder(groups);
        }

        public final String getInclude() {
            return this.include;
        }

        @Override
        public final Builder include(String include) {
            this.include = include;
            return this;
        }

        @Override
        public final Builder include(Include include) {
            this.include(include == null ? null : include.toString());
            return this;
        }

        public final void setInclude(String include) {
            this.include = include;
        }

        public SegmentGroupList build() {
            return new SegmentGroupList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SegmentGroupList> {
        public Builder groups(Collection<SegmentGroup> var1);

        public Builder groups(SegmentGroup ... var1);

        public Builder groups(Consumer<SegmentGroup.Builder> ... var1);

        public Builder include(String var1);

        public Builder include(Include var1);
    }
}

