/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.GPSCoordinates;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GPSPointDimension
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GPSPointDimension> {
    private static final SdkField<GPSCoordinates> COORDINATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Coordinates").getter(GPSPointDimension.getter(GPSPointDimension::coordinates)).setter(GPSPointDimension.setter(Builder::coordinates)).constructor(GPSCoordinates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Coordinates").build()}).build();
    private static final SdkField<Double> RANGE_IN_KILOMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("RangeInKilometers").getter(GPSPointDimension.getter(GPSPointDimension::rangeInKilometers)).setter(GPSPointDimension.setter(Builder::rangeInKilometers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeInKilometers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COORDINATES_FIELD, RANGE_IN_KILOMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final GPSCoordinates coordinates;
    private final Double rangeInKilometers;

    private GPSPointDimension(BuilderImpl builder) {
        this.coordinates = builder.coordinates;
        this.rangeInKilometers = builder.rangeInKilometers;
    }

    public final GPSCoordinates coordinates() {
        return this.coordinates;
    }

    public final Double rangeInKilometers() {
        return this.rangeInKilometers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coordinates());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeInKilometers());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GPSPointDimension)) {
            return false;
        }
        GPSPointDimension other = (GPSPointDimension)obj;
        return Objects.equals(this.coordinates(), other.coordinates()) && Objects.equals(this.rangeInKilometers(), other.rangeInKilometers());
    }

    public final String toString() {
        return ToString.builder((String)"GPSPointDimension").add("Coordinates", (Object)this.coordinates()).add("RangeInKilometers", (Object)this.rangeInKilometers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Coordinates": {
                return Optional.ofNullable(clazz.cast(this.coordinates()));
            }
            case "RangeInKilometers": {
                return Optional.ofNullable(clazz.cast(this.rangeInKilometers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GPSPointDimension, T> g) {
        return obj -> g.apply((GPSPointDimension)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GPSCoordinates coordinates;
        private Double rangeInKilometers;

        private BuilderImpl() {
        }

        private BuilderImpl(GPSPointDimension model) {
            this.coordinates(model.coordinates);
            this.rangeInKilometers(model.rangeInKilometers);
        }

        public final GPSCoordinates.Builder getCoordinates() {
            return this.coordinates != null ? this.coordinates.toBuilder() : null;
        }

        @Override
        public final Builder coordinates(GPSCoordinates coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public final void setCoordinates(GPSCoordinates.BuilderImpl coordinates) {
            this.coordinates = coordinates != null ? coordinates.build() : null;
        }

        public final Double getRangeInKilometers() {
            return this.rangeInKilometers;
        }

        @Override
        public final Builder rangeInKilometers(Double rangeInKilometers) {
            this.rangeInKilometers = rangeInKilometers;
            return this;
        }

        public final void setRangeInKilometers(Double rangeInKilometers) {
            this.rangeInKilometers = rangeInKilometers;
        }

        public GPSPointDimension build() {
            return new GPSPointDimension(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GPSPointDimension> {
        public Builder coordinates(GPSCoordinates var1);

        default public Builder coordinates(Consumer<GPSCoordinates.Builder> coordinates) {
            return this.coordinates((GPSCoordinates)((GPSCoordinates.Builder)GPSCoordinates.builder().applyMutation(coordinates)).build());
        }

        public Builder rangeInKilometers(Double var1);
    }
}

