/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.ChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.MapOfChannelResponseCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelsResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelsResponse> {
    private static final SdkField<Map<String, ChannelResponse>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Channels").getter(ChannelsResponse.getter(ChannelsResponse::channels)).setter(ChannelsResponse.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, ChannelResponse> channels;

    private ChannelsResponse(BuilderImpl builder) {
        this.channels = builder.channels;
    }

    public final boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructMap);
    }

    public final Map<String, ChannelResponse> channels() {
        return this.channels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelsResponse)) {
            return false;
        }
        ChannelsResponse other = (ChannelsResponse)obj;
        return this.hasChannels() == other.hasChannels() && Objects.equals(this.channels(), other.channels());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelsResponse").add("Channels", this.hasChannels() ? this.channels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelsResponse, T> g) {
        return obj -> g.apply((ChannelsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, ChannelResponse> channels = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelsResponse model) {
            this.channels(model.channels);
        }

        public final Map<String, ChannelResponse.Builder> getChannels() {
            if (this.channels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.channels != null ? CollectionUtils.mapValues(this.channels, ChannelResponse::toBuilder) : null;
        }

        @Override
        public final Builder channels(Map<String, ChannelResponse> channels) {
            this.channels = MapOfChannelResponseCopier.copy(channels);
            return this;
        }

        public final void setChannels(Map<String, ChannelResponse.BuilderImpl> channels) {
            this.channels = MapOfChannelResponseCopier.copyFromBuilder(channels);
        }

        public ChannelsResponse build() {
            return new ChannelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelsResponse> {
        public Builder channels(Map<String, ChannelResponse> var1);
    }
}

