/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.ListOfResultRowCopier;
import software.amazon.awssdk.services.pinpoint.model.ResultRow;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BaseKpiResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BaseKpiResult> {
    private static final SdkField<List<ResultRow>> ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rows").getter(BaseKpiResult.getter(BaseKpiResult::rows)).setter(BaseKpiResult.setter(Builder::rows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResultRow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROWS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ResultRow> rows;

    private BaseKpiResult(BuilderImpl builder) {
        this.rows = builder.rows;
    }

    public boolean hasRows() {
        return this.rows != null && !(this.rows instanceof SdkAutoConstructList);
    }

    public List<ResultRow> rows() {
        return this.rows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rows());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseKpiResult)) {
            return false;
        }
        BaseKpiResult other = (BaseKpiResult)obj;
        return Objects.equals(this.rows(), other.rows());
    }

    public String toString() {
        return ToString.builder((String)"BaseKpiResult").add("Rows", this.rows()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rows": {
                return Optional.ofNullable(clazz.cast(this.rows()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BaseKpiResult, T> g) {
        return obj -> g.apply((BaseKpiResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ResultRow> rows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BaseKpiResult model) {
            this.rows(model.rows);
        }

        public final Collection<ResultRow.Builder> getRows() {
            return this.rows != null ? (Collection)this.rows.stream().map(ResultRow::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rows(Collection<ResultRow> rows) {
            this.rows = ListOfResultRowCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(ResultRow ... rows) {
            this.rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<ResultRow.Builder> ... rows) {
            this.rows(Stream.of(rows).map(c -> (ResultRow)((ResultRow.Builder)ResultRow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRows(Collection<ResultRow.BuilderImpl> rows) {
            this.rows = ListOfResultRowCopier.copyFromBuilder(rows);
        }

        public BaseKpiResult build() {
            return new BaseKpiResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BaseKpiResult> {
        public Builder rows(Collection<ResultRow> var1);

        public Builder rows(ResultRow ... var1);

        public Builder rows(Consumer<ResultRow.Builder> ... var1);
    }
}

