/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.EndpointMessageResult;
import software.amazon.awssdk.services.pinpoint.model.MapOfMapOfEndpointMessageResultCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendUsersMessageResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SendUsersMessageResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(SendUsersMessageResponse.getter(SendUsersMessageResponse::applicationId)).setter(SendUsersMessageResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(SendUsersMessageResponse.getter(SendUsersMessageResponse::requestId)).setter(SendUsersMessageResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Map<String, Map<String, EndpointMessageResult>>> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Result").getter(SendUsersMessageResponse.getter(SendUsersMessageResponse::result)).setter(SendUsersMessageResponse.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointMessageResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, REQUEST_ID_FIELD, RESULT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String requestId;
    private final Map<String, Map<String, EndpointMessageResult>> result;

    private SendUsersMessageResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.requestId = builder.requestId;
        this.result = builder.result;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String requestId() {
        return this.requestId;
    }

    public boolean hasResult() {
        return this.result != null && !(this.result instanceof SdkAutoConstructMap);
    }

    public Map<String, Map<String, EndpointMessageResult>> result() {
        return this.result;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResult() ? this.result() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendUsersMessageResponse)) {
            return false;
        }
        SendUsersMessageResponse other = (SendUsersMessageResponse)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.requestId(), other.requestId()) && this.hasResult() == other.hasResult() && Objects.equals(this.result(), other.result());
    }

    public String toString() {
        return ToString.builder((String)"SendUsersMessageResponse").add("ApplicationId", (Object)this.applicationId()).add("RequestId", (Object)this.requestId()).add("Result", this.hasResult() ? this.result() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendUsersMessageResponse, T> g) {
        return obj -> g.apply((SendUsersMessageResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String requestId;
        private Map<String, Map<String, EndpointMessageResult>> result = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendUsersMessageResponse model) {
            this.applicationId(model.applicationId);
            this.requestId(model.requestId);
            this.result(model.result);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Map<String, Map<String, EndpointMessageResult>> getResult() {
            if (this.result instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.result;
        }

        @Override
        public final Builder result(Map<String, Map<String, EndpointMessageResult>> result) {
            this.result = MapOfMapOfEndpointMessageResultCopier.copy(result);
            return this;
        }

        public final void setResult(Map<String, Map<String, EndpointMessageResult>> result) {
            this.result = MapOfMapOfEndpointMessageResultCopier.copy(result);
        }

        public SendUsersMessageResponse build() {
            return new SendUsersMessageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SendUsersMessageResponse> {
        public Builder applicationId(String var1);

        public Builder requestId(String var1);

        public Builder result(Map<String, Map<String, EndpointMessageResult>> var1);
    }
}

