/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.ExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.ListOfExportJobResponseCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportJobsResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportJobsResponse> {
    private static final SdkField<List<ExportJobResponse>> ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Item").getter(ExportJobsResponse.getter(ExportJobsResponse::item)).setter(ExportJobsResponse.setter(Builder::item)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportJobResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ExportJobsResponse.getter(ExportJobsResponse::nextToken)).setter(ExportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD, NEXT_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ExportJobResponse> item;
    private final String nextToken;

    private ExportJobsResponse(BuilderImpl builder) {
        this.item = builder.item;
        this.nextToken = builder.nextToken;
    }

    public boolean hasItem() {
        return this.item != null && !(this.item instanceof SdkAutoConstructList);
    }

    public List<ExportJobResponse> item() {
        return this.item;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.item());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportJobsResponse)) {
            return false;
        }
        ExportJobsResponse other = (ExportJobsResponse)obj;
        return Objects.equals(this.item(), other.item()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ExportJobsResponse").add("Item", this.item()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportJobsResponse, T> g) {
        return obj -> g.apply((ExportJobsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ExportJobResponse> item = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportJobsResponse model) {
            this.item(model.item);
            this.nextToken(model.nextToken);
        }

        public final Collection<ExportJobResponse.Builder> getItem() {
            return this.item != null ? (Collection)this.item.stream().map(ExportJobResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<ExportJobResponse> item) {
            this.item = ListOfExportJobResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(ExportJobResponse ... item) {
            this.item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<ExportJobResponse.Builder> ... item) {
            this.item(Stream.of(item).map(c -> (ExportJobResponse)((ExportJobResponse.Builder)ExportJobResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItem(Collection<ExportJobResponse.BuilderImpl> item) {
            this.item = ListOfExportJobResponseCopier.copyFromBuilder(item);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ExportJobsResponse build() {
            return new ExportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportJobsResponse> {
        public Builder item(Collection<ExportJobResponse> var1);

        public Builder item(ExportJobResponse ... var1);

        public Builder item(Consumer<ExportJobResponse.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

