/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.Action;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class APNSPushNotificationTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, APNSPushNotificationTemplate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(APNSPushNotificationTemplate.getter(APNSPushNotificationTemplate::actionAsString)).setter(APNSPushNotificationTemplate.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(APNSPushNotificationTemplate.getter(APNSPushNotificationTemplate::body)).setter(APNSPushNotificationTemplate.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> MEDIA_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(APNSPushNotificationTemplate.getter(APNSPushNotificationTemplate::mediaUrl)).setter(APNSPushNotificationTemplate.setter(Builder::mediaUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaUrl").build()}).build();
    private static final SdkField<String> RAW_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(APNSPushNotificationTemplate.getter(APNSPushNotificationTemplate::rawContent)).setter(APNSPushNotificationTemplate.setter(Builder::rawContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()}).build();
    private static final SdkField<String> SOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(APNSPushNotificationTemplate.getter(APNSPushNotificationTemplate::sound)).setter(APNSPushNotificationTemplate.setter(Builder::sound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sound").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(APNSPushNotificationTemplate.getter(APNSPushNotificationTemplate::title)).setter(APNSPushNotificationTemplate.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(APNSPushNotificationTemplate.getter(APNSPushNotificationTemplate::url)).setter(APNSPushNotificationTemplate.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BODY_FIELD, MEDIA_URL_FIELD, RAW_CONTENT_FIELD, SOUND_FIELD, TITLE_FIELD, URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final String body;
    private final String mediaUrl;
    private final String rawContent;
    private final String sound;
    private final String title;
    private final String url;

    private APNSPushNotificationTemplate(BuilderImpl builder) {
        this.action = builder.action;
        this.body = builder.body;
        this.mediaUrl = builder.mediaUrl;
        this.rawContent = builder.rawContent;
        this.sound = builder.sound;
        this.title = builder.title;
        this.url = builder.url;
    }

    public Action action() {
        return Action.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public String body() {
        return this.body;
    }

    public String mediaUrl() {
        return this.mediaUrl;
    }

    public String rawContent() {
        return this.rawContent;
    }

    public String sound() {
        return this.sound;
    }

    public String title() {
        return this.title;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.sound());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APNSPushNotificationTemplate)) {
            return false;
        }
        APNSPushNotificationTemplate other = (APNSPushNotificationTemplate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.mediaUrl(), other.mediaUrl()) && Objects.equals(this.rawContent(), other.rawContent()) && Objects.equals(this.sound(), other.sound()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.url(), other.url());
    }

    public String toString() {
        return ToString.builder((String)"APNSPushNotificationTemplate").add("Action", (Object)this.actionAsString()).add("Body", (Object)this.body()).add("MediaUrl", (Object)this.mediaUrl()).add("RawContent", (Object)this.rawContent()).add("Sound", (Object)this.sound()).add("Title", (Object)this.title()).add("Url", (Object)this.url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "MediaUrl": {
                return Optional.ofNullable(clazz.cast(this.mediaUrl()));
            }
            case "RawContent": {
                return Optional.ofNullable(clazz.cast(this.rawContent()));
            }
            case "Sound": {
                return Optional.ofNullable(clazz.cast(this.sound()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<APNSPushNotificationTemplate, T> g) {
        return obj -> g.apply((APNSPushNotificationTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String body;
        private String mediaUrl;
        private String rawContent;
        private String sound;
        private String title;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(APNSPushNotificationTemplate model) {
            this.action(model.action);
            this.body(model.body);
            this.mediaUrl(model.mediaUrl);
            this.rawContent(model.rawContent);
            this.sound(model.sound);
            this.title(model.title);
            this.url(model.url);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getMediaUrl() {
            return this.mediaUrl;
        }

        @Override
        public final Builder mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public final void setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        public final String getRawContent() {
            return this.rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final String getSound() {
            return this.sound;
        }

        @Override
        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final void setSound(String sound) {
            this.sound = sound;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public APNSPushNotificationTemplate build() {
            return new APNSPushNotificationTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, APNSPushNotificationTemplate> {
        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder body(String var1);

        public Builder mediaUrl(String var1);

        public Builder rawContent(String var1);

        public Builder sound(String var1);

        public Builder title(String var1);

        public Builder url(String var1);
    }
}

