/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.VoiceTemplateRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVoiceTemplateRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateVoiceTemplateRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateVoiceTemplateRequest.getter(UpdateVoiceTemplateRequest::templateName)).setter(UpdateVoiceTemplateRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("template-name").build()}).build();
    private static final SdkField<VoiceTemplateRequest> VOICE_TEMPLATE_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateVoiceTemplateRequest.getter(UpdateVoiceTemplateRequest::voiceTemplateRequest)).setter(UpdateVoiceTemplateRequest.setter(Builder::voiceTemplateRequest)).constructor(VoiceTemplateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceTemplateRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, VOICE_TEMPLATE_REQUEST_FIELD));
    private final String templateName;
    private final VoiceTemplateRequest voiceTemplateRequest;

    private UpdateVoiceTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.voiceTemplateRequest = builder.voiceTemplateRequest;
    }

    public String templateName() {
        return this.templateName;
    }

    public VoiceTemplateRequest voiceTemplateRequest() {
        return this.voiceTemplateRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceTemplateRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVoiceTemplateRequest)) {
            return false;
        }
        UpdateVoiceTemplateRequest other = (UpdateVoiceTemplateRequest)((Object)obj);
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.voiceTemplateRequest(), other.voiceTemplateRequest());
    }

    public String toString() {
        return ToString.builder((String)"UpdateVoiceTemplateRequest").add("TemplateName", (Object)this.templateName()).add("VoiceTemplateRequest", (Object)this.voiceTemplateRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "VoiceTemplateRequest": {
                return Optional.ofNullable(clazz.cast(this.voiceTemplateRequest()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVoiceTemplateRequest, T> g) {
        return obj -> g.apply((UpdateVoiceTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String templateName;
        private VoiceTemplateRequest voiceTemplateRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVoiceTemplateRequest model) {
            super(model);
            this.templateName(model.templateName);
            this.voiceTemplateRequest(model.voiceTemplateRequest);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final VoiceTemplateRequest.Builder getVoiceTemplateRequest() {
            return this.voiceTemplateRequest != null ? this.voiceTemplateRequest.toBuilder() : null;
        }

        @Override
        public final Builder voiceTemplateRequest(VoiceTemplateRequest voiceTemplateRequest) {
            this.voiceTemplateRequest = voiceTemplateRequest;
            return this;
        }

        public final void setVoiceTemplateRequest(VoiceTemplateRequest.BuilderImpl voiceTemplateRequest) {
            this.voiceTemplateRequest = voiceTemplateRequest != null ? voiceTemplateRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVoiceTemplateRequest build() {
            return new UpdateVoiceTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVoiceTemplateRequest> {
        public Builder templateName(String var1);

        public Builder voiceTemplateRequest(VoiceTemplateRequest var1);

        default public Builder voiceTemplateRequest(Consumer<VoiceTemplateRequest.Builder> voiceTemplateRequest) {
            return this.voiceTemplateRequest((VoiceTemplateRequest)((VoiceTemplateRequest.Builder)VoiceTemplateRequest.builder().applyMutation(voiceTemplateRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

