/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetJourneyExecutionActivityMetricsRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, GetJourneyExecutionActivityMetricsRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetJourneyExecutionActivityMetricsRequest.getter(GetJourneyExecutionActivityMetricsRequest::applicationId)).setter(GetJourneyExecutionActivityMetricsRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<String> JOURNEY_ACTIVITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetJourneyExecutionActivityMetricsRequest.getter(GetJourneyExecutionActivityMetricsRequest::journeyActivityId)).setter(GetJourneyExecutionActivityMetricsRequest.setter(Builder::journeyActivityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("journey-activity-id").build()}).build();
    private static final SdkField<String> JOURNEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetJourneyExecutionActivityMetricsRequest.getter(GetJourneyExecutionActivityMetricsRequest::journeyId)).setter(GetJourneyExecutionActivityMetricsRequest.setter(Builder::journeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("journey-id").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetJourneyExecutionActivityMetricsRequest.getter(GetJourneyExecutionActivityMetricsRequest::nextToken)).setter(GetJourneyExecutionActivityMetricsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()}).build();
    private static final SdkField<String> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetJourneyExecutionActivityMetricsRequest.getter(GetJourneyExecutionActivityMetricsRequest::pageSize)).setter(GetJourneyExecutionActivityMetricsRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("page-size").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, JOURNEY_ACTIVITY_ID_FIELD, JOURNEY_ID_FIELD, NEXT_TOKEN_FIELD, PAGE_SIZE_FIELD));
    private final String applicationId;
    private final String journeyActivityId;
    private final String journeyId;
    private final String nextToken;
    private final String pageSize;

    private GetJourneyExecutionActivityMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.journeyActivityId = builder.journeyActivityId;
        this.journeyId = builder.journeyId;
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String journeyActivityId() {
        return this.journeyActivityId;
    }

    public String journeyId() {
        return this.journeyId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String pageSize() {
        return this.pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.journeyActivityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.journeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJourneyExecutionActivityMetricsRequest)) {
            return false;
        }
        GetJourneyExecutionActivityMetricsRequest other = (GetJourneyExecutionActivityMetricsRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.journeyActivityId(), other.journeyActivityId()) && Objects.equals(this.journeyId(), other.journeyId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.pageSize(), other.pageSize());
    }

    public String toString() {
        return ToString.builder((String)"GetJourneyExecutionActivityMetricsRequest").add("ApplicationId", (Object)this.applicationId()).add("JourneyActivityId", (Object)this.journeyActivityId()).add("JourneyId", (Object)this.journeyId()).add("NextToken", (Object)this.nextToken()).add("PageSize", (Object)this.pageSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "JourneyActivityId": {
                return Optional.ofNullable(clazz.cast(this.journeyActivityId()));
            }
            case "JourneyId": {
                return Optional.ofNullable(clazz.cast(this.journeyId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJourneyExecutionActivityMetricsRequest, T> g) {
        return obj -> g.apply((GetJourneyExecutionActivityMetricsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String journeyActivityId;
        private String journeyId;
        private String nextToken;
        private String pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJourneyExecutionActivityMetricsRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.journeyActivityId(model.journeyActivityId);
            this.journeyId(model.journeyId);
            this.nextToken(model.nextToken);
            this.pageSize(model.pageSize);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getJourneyActivityId() {
            return this.journeyActivityId;
        }

        @Override
        public final Builder journeyActivityId(String journeyActivityId) {
            this.journeyActivityId = journeyActivityId;
            return this;
        }

        public final void setJourneyActivityId(String journeyActivityId) {
            this.journeyActivityId = journeyActivityId;
        }

        public final String getJourneyId() {
            return this.journeyId;
        }

        @Override
        public final Builder journeyId(String journeyId) {
            this.journeyId = journeyId;
            return this;
        }

        public final void setJourneyId(String journeyId) {
            this.journeyId = journeyId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(String pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetJourneyExecutionActivityMetricsRequest build() {
            return new GetJourneyExecutionActivityMetricsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetJourneyExecutionActivityMetricsRequest> {
        public Builder applicationId(String var1);

        public Builder journeyActivityId(String var1);

        public Builder journeyId(String var1);

        public Builder nextToken(String var1);

        public Builder pageSize(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

