/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.SegmentDimensions;
import software.amazon.awssdk.services.pinpoint.model.SegmentGroupList;
import software.amazon.awssdk.services.pinpoint.model.SegmentImportResource;
import software.amazon.awssdk.services.pinpoint.model.SegmentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SegmentResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SegmentResponse.getter(SegmentResponse::applicationId)).setter(SegmentResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SegmentResponse.getter(SegmentResponse::creationDate)).setter(SegmentResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<SegmentDimensions> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SegmentResponse.getter(SegmentResponse::dimensions)).setter(SegmentResponse.setter(Builder::dimensions)).constructor(SegmentDimensions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SegmentResponse.getter(SegmentResponse::id)).setter(SegmentResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<SegmentImportResource> IMPORT_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SegmentResponse.getter(SegmentResponse::importDefinition)).setter(SegmentResponse.setter(Builder::importDefinition)).constructor(SegmentImportResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDefinition").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SegmentResponse.getter(SegmentResponse::lastModifiedDate)).setter(SegmentResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SegmentResponse.getter(SegmentResponse::name)).setter(SegmentResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<SegmentGroupList> SEGMENT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SegmentResponse.getter(SegmentResponse::segmentGroups)).setter(SegmentResponse.setter(Builder::segmentGroups)).constructor(SegmentGroupList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentGroups").build()}).build();
    private static final SdkField<String> SEGMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SegmentResponse.getter(SegmentResponse::segmentTypeAsString)).setter(SegmentResponse.setter(Builder::segmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentType").build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SegmentResponse.getter(SegmentResponse::version)).setter(SegmentResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CREATION_DATE_FIELD, DIMENSIONS_FIELD, ID_FIELD, IMPORT_DEFINITION_FIELD, LAST_MODIFIED_DATE_FIELD, NAME_FIELD, SEGMENT_GROUPS_FIELD, SEGMENT_TYPE_FIELD, VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String creationDate;
    private final SegmentDimensions dimensions;
    private final String id;
    private final SegmentImportResource importDefinition;
    private final String lastModifiedDate;
    private final String name;
    private final SegmentGroupList segmentGroups;
    private final String segmentType;
    private final Integer version;

    private SegmentResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.creationDate = builder.creationDate;
        this.dimensions = builder.dimensions;
        this.id = builder.id;
        this.importDefinition = builder.importDefinition;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.name = builder.name;
        this.segmentGroups = builder.segmentGroups;
        this.segmentType = builder.segmentType;
        this.version = builder.version;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public SegmentDimensions dimensions() {
        return this.dimensions;
    }

    public String id() {
        return this.id;
    }

    public SegmentImportResource importDefinition() {
        return this.importDefinition;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String name() {
        return this.name;
    }

    public SegmentGroupList segmentGroups() {
        return this.segmentGroups;
    }

    public SegmentType segmentType() {
        return SegmentType.fromValue(this.segmentType);
    }

    public String segmentTypeAsString() {
        return this.segmentType;
    }

    public Integer version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.importDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentResponse)) {
            return false;
        }
        SegmentResponse other = (SegmentResponse)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.importDefinition(), other.importDefinition()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.segmentGroups(), other.segmentGroups()) && Objects.equals(this.segmentTypeAsString(), other.segmentTypeAsString()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"SegmentResponse").add("ApplicationId", (Object)this.applicationId()).add("CreationDate", (Object)this.creationDate()).add("Dimensions", (Object)this.dimensions()).add("Id", (Object)this.id()).add("ImportDefinition", (Object)this.importDefinition()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Name", (Object)this.name()).add("SegmentGroups", (Object)this.segmentGroups()).add("SegmentType", (Object)this.segmentTypeAsString()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ImportDefinition": {
                return Optional.ofNullable(clazz.cast(this.importDefinition()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SegmentGroups": {
                return Optional.ofNullable(clazz.cast(this.segmentGroups()));
            }
            case "SegmentType": {
                return Optional.ofNullable(clazz.cast(this.segmentTypeAsString()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentResponse, T> g) {
        return obj -> g.apply((SegmentResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String creationDate;
        private SegmentDimensions dimensions;
        private String id;
        private SegmentImportResource importDefinition;
        private String lastModifiedDate;
        private String name;
        private SegmentGroupList segmentGroups;
        private String segmentType;
        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentResponse model) {
            this.applicationId(model.applicationId);
            this.creationDate(model.creationDate);
            this.dimensions(model.dimensions);
            this.id(model.id);
            this.importDefinition(model.importDefinition);
            this.lastModifiedDate(model.lastModifiedDate);
            this.name(model.name);
            this.segmentGroups(model.segmentGroups);
            this.segmentType(model.segmentType);
            this.version(model.version);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final SegmentDimensions.Builder getDimensions() {
            return this.dimensions != null ? this.dimensions.toBuilder() : null;
        }

        @Override
        public final Builder dimensions(SegmentDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(SegmentDimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final SegmentImportResource.Builder getImportDefinition() {
            return this.importDefinition != null ? this.importDefinition.toBuilder() : null;
        }

        @Override
        public final Builder importDefinition(SegmentImportResource importDefinition) {
            this.importDefinition = importDefinition;
            return this;
        }

        public final void setImportDefinition(SegmentImportResource.BuilderImpl importDefinition) {
            this.importDefinition = importDefinition != null ? importDefinition.build() : null;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final SegmentGroupList.Builder getSegmentGroups() {
            return this.segmentGroups != null ? this.segmentGroups.toBuilder() : null;
        }

        @Override
        public final Builder segmentGroups(SegmentGroupList segmentGroups) {
            this.segmentGroups = segmentGroups;
            return this;
        }

        public final void setSegmentGroups(SegmentGroupList.BuilderImpl segmentGroups) {
            this.segmentGroups = segmentGroups != null ? segmentGroups.build() : null;
        }

        public final String getSegmentType() {
            return this.segmentType;
        }

        @Override
        public final Builder segmentType(String segmentType) {
            this.segmentType = segmentType;
            return this;
        }

        @Override
        public final Builder segmentType(SegmentType segmentType) {
            this.segmentType(segmentType.toString());
            return this;
        }

        public final void setSegmentType(String segmentType) {
            this.segmentType = segmentType;
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public SegmentResponse build() {
            return new SegmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SegmentResponse> {
        public Builder applicationId(String var1);

        public Builder creationDate(String var1);

        public Builder dimensions(SegmentDimensions var1);

        default public Builder dimensions(Consumer<SegmentDimensions.Builder> dimensions) {
            return this.dimensions((SegmentDimensions)((SegmentDimensions.Builder)SegmentDimensions.builder().applyMutation(dimensions)).build());
        }

        public Builder id(String var1);

        public Builder importDefinition(SegmentImportResource var1);

        default public Builder importDefinition(Consumer<SegmentImportResource.Builder> importDefinition) {
            return this.importDefinition((SegmentImportResource)((SegmentImportResource.Builder)SegmentImportResource.builder().applyMutation(importDefinition)).build());
        }

        public Builder lastModifiedDate(String var1);

        public Builder name(String var1);

        public Builder segmentGroups(SegmentGroupList var1);

        default public Builder segmentGroups(Consumer<SegmentGroupList.Builder> segmentGroups) {
            return this.segmentGroups((SegmentGroupList)((SegmentGroupList.Builder)SegmentGroupList.builder().applyMutation(segmentGroups)).build());
        }

        public Builder segmentType(String var1);

        public Builder segmentType(SegmentType var1);

        public Builder version(Integer var1);
    }
}

