/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.SegmentLocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SegmentLocationMarshaller {
    private static final MarshallingInfo<StructuredPojo> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Country").isBinary(false).build();
    private static final SegmentLocationMarshaller INSTANCE = new SegmentLocationMarshaller();

    private SegmentLocationMarshaller() {
    }

    public static SegmentLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SegmentLocation segmentLocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)segmentLocation, (String)"segmentLocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)segmentLocation.country(), COUNTRY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

