/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.RecencyDimension;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RecencyDimensionMarshaller {
    private static final MarshallingInfo<String> DURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Duration").isBinary(false).build();
    private static final MarshallingInfo<String> RECENCYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecencyType").isBinary(false).build();
    private static final RecencyDimensionMarshaller INSTANCE = new RecencyDimensionMarshaller();

    private RecencyDimensionMarshaller() {
    }

    public static RecencyDimensionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RecencyDimension recencyDimension, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)recencyDimension, (String)"recencyDimension");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)recencyDimension.durationString(), DURATION_BINDING);
            protocolMarshaller.marshall((Object)recencyDimension.recencyTypeString(), RECENCYTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

