/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.MessageRequest;
import software.amazon.awssdk.services.pinpoint.transform.AddressConfigurationUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DirectMessageConfigurationUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.EndpointSendConfigurationUnmarshaller;

public class MessageRequestUnmarshaller
implements Unmarshaller<MessageRequest, JsonUnmarshallerContext> {
    private static final MessageRequestUnmarshaller INSTANCE = new MessageRequestUnmarshaller();

    public MessageRequest unmarshall(JsonUnmarshallerContext context) throws Exception {
        MessageRequest.Builder messageRequestBuilder = MessageRequest.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Addresses", targetDepth)) {
                    context.nextToken();
                    messageRequestBuilder.addresses(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)AddressConfigurationUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Context", targetDepth)) {
                    context.nextToken();
                    messageRequestBuilder.context(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Endpoints", targetDepth)) {
                    context.nextToken();
                    messageRequestBuilder.endpoints(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)EndpointSendConfigurationUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("MessageConfiguration", targetDepth)) {
                    context.nextToken();
                    messageRequestBuilder.messageConfiguration(DirectMessageConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (MessageRequest)messageRequestBuilder.build();
    }

    public static MessageRequestUnmarshaller getInstance() {
        return INSTANCE;
    }
}

