/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateImportJobRequestModelMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("application-id").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> IMPORTJOBREQUEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).isBinary(false).build();
    private static final CreateImportJobRequestModelMarshaller INSTANCE = new CreateImportJobRequestModelMarshaller();

    private CreateImportJobRequestModelMarshaller() {
    }

    public static CreateImportJobRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateImportJobRequest createImportJobRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createImportJobRequest), (String)"createImportJobRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createImportJobRequest.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)createImportJobRequest.importJobRequest(), IMPORTJOBREQUEST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

