/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.AddressConfiguration;

public class AddressConfigurationUnmarshaller
implements Unmarshaller<AddressConfiguration, JsonUnmarshallerContext> {
    private static final AddressConfigurationUnmarshaller INSTANCE = new AddressConfigurationUnmarshaller();

    public AddressConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        AddressConfiguration.Builder addressConfigurationBuilder = AddressConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BodyOverride", targetDepth)) {
                    context.nextToken();
                    addressConfigurationBuilder.bodyOverride((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ChannelType", targetDepth)) {
                    context.nextToken();
                    addressConfigurationBuilder.channelType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Context", targetDepth)) {
                    context.nextToken();
                    addressConfigurationBuilder.context(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("RawContent", targetDepth)) {
                    context.nextToken();
                    addressConfigurationBuilder.rawContent((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Substitutions", targetDepth)) {
                    context.nextToken();
                    addressConfigurationBuilder.substitutions(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("TitleOverride", targetDepth)) {
                    context.nextToken();
                    addressConfigurationBuilder.titleOverride((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AddressConfiguration)addressConfigurationBuilder.build();
    }

    public static AddressConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

