/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.ActivityResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ActivityResponseMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").isBinary(false).build();
    private static final MarshallingInfo<String> CAMPAIGNID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CampaignId").isBinary(false).build();
    private static final MarshallingInfo<String> END_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("End").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> RESULT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Result").isBinary(false).build();
    private static final MarshallingInfo<String> SCHEDULEDSTART_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScheduledStart").isBinary(false).build();
    private static final MarshallingInfo<String> START_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Start").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<Integer> SUCCESSFULENDPOINTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SuccessfulEndpointCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEZONESCOMPLETEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimezonesCompletedCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEZONESTOTALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimezonesTotalCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> TOTALENDPOINTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalEndpointCount").isBinary(false).build();
    private static final MarshallingInfo<String> TREATMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TreatmentId").isBinary(false).build();
    private static final ActivityResponseMarshaller INSTANCE = new ActivityResponseMarshaller();

    private ActivityResponseMarshaller() {
    }

    public static ActivityResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ActivityResponse activityResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)activityResponse, (String)"activityResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)activityResponse.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.campaignId(), CAMPAIGNID_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.end(), END_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.result(), RESULT_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.scheduledStart(), SCHEDULEDSTART_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.start(), START_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.state(), STATE_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.successfulEndpointCount(), SUCCESSFULENDPOINTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.timezonesCompletedCount(), TIMEZONESCOMPLETEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.timezonesTotalCount(), TIMEZONESTOTALCOUNT_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.totalEndpointCount(), TOTALENDPOINTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)activityResponse.treatmentId(), TREATMENTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

