/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.AttributeDimension;
import software.amazon.awssdk.services.pinpoint.model.MapOfAttributeDimensionCopier;
import software.amazon.awssdk.services.pinpoint.model.SegmentBehaviors;
import software.amazon.awssdk.services.pinpoint.model.SegmentDemographics;
import software.amazon.awssdk.services.pinpoint.model.SegmentLocation;
import software.amazon.awssdk.services.pinpoint.transform.SegmentDimensionsMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SegmentDimensions
implements StructuredPojo,
ToCopyableBuilder<Builder, SegmentDimensions> {
    private final Map<String, AttributeDimension> attributes;
    private final SegmentBehaviors behavior;
    private final SegmentDemographics demographic;
    private final SegmentLocation location;
    private final Map<String, AttributeDimension> userAttributes;

    private SegmentDimensions(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.behavior = builder.behavior;
        this.demographic = builder.demographic;
        this.location = builder.location;
        this.userAttributes = builder.userAttributes;
    }

    public Map<String, AttributeDimension> attributes() {
        return this.attributes;
    }

    public SegmentBehaviors behavior() {
        return this.behavior;
    }

    public SegmentDemographics demographic() {
        return this.demographic;
    }

    public SegmentLocation location() {
        return this.location;
    }

    public Map<String, AttributeDimension> userAttributes() {
        return this.userAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.behavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.demographic());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentDimensions)) {
            return false;
        }
        SegmentDimensions other = (SegmentDimensions)obj;
        return Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.behavior(), other.behavior()) && Objects.equals(this.demographic(), other.demographic()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.userAttributes(), other.userAttributes());
    }

    public String toString() {
        return ToString.builder((String)"SegmentDimensions").add("Attributes", this.attributes()).add("Behavior", (Object)this.behavior()).add("Demographic", (Object)this.demographic()).add("Location", (Object)this.location()).add("UserAttributes", this.userAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
            case "Behavior": {
                return Optional.of(clazz.cast(this.behavior()));
            }
            case "Demographic": {
                return Optional.of(clazz.cast(this.demographic()));
            }
            case "Location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "UserAttributes": {
                return Optional.of(clazz.cast(this.userAttributes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentDimensionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeDimension> attributes;
        private SegmentBehaviors behavior;
        private SegmentDemographics demographic;
        private SegmentLocation location;
        private Map<String, AttributeDimension> userAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentDimensions model) {
            this.attributes(model.attributes);
            this.behavior(model.behavior);
            this.demographic(model.demographic);
            this.location(model.location);
            this.userAttributes(model.userAttributes);
        }

        public final Map<String, AttributeDimension.Builder> getAttributes() {
            return this.attributes != null ? CollectionUtils.mapValues(this.attributes, AttributeDimension::toBuilder) : null;
        }

        @Override
        public final Builder attributes(Map<String, AttributeDimension> attributes) {
            this.attributes = MapOfAttributeDimensionCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, AttributeDimension.BuilderImpl> attributes) {
            this.attributes = MapOfAttributeDimensionCopier.copyFromBuilder(attributes);
        }

        public final SegmentBehaviors.Builder getBehavior() {
            return this.behavior != null ? this.behavior.toBuilder() : null;
        }

        @Override
        public final Builder behavior(SegmentBehaviors behavior) {
            this.behavior = behavior;
            return this;
        }

        public final void setBehavior(SegmentBehaviors.BuilderImpl behavior) {
            this.behavior = behavior != null ? behavior.build() : null;
        }

        public final SegmentDemographics.Builder getDemographic() {
            return this.demographic != null ? this.demographic.toBuilder() : null;
        }

        @Override
        public final Builder demographic(SegmentDemographics demographic) {
            this.demographic = demographic;
            return this;
        }

        public final void setDemographic(SegmentDemographics.BuilderImpl demographic) {
            this.demographic = demographic != null ? demographic.build() : null;
        }

        public final SegmentLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(SegmentLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(SegmentLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final Map<String, AttributeDimension.Builder> getUserAttributes() {
            return this.userAttributes != null ? CollectionUtils.mapValues(this.userAttributes, AttributeDimension::toBuilder) : null;
        }

        @Override
        public final Builder userAttributes(Map<String, AttributeDimension> userAttributes) {
            this.userAttributes = MapOfAttributeDimensionCopier.copy(userAttributes);
            return this;
        }

        public final void setUserAttributes(Map<String, AttributeDimension.BuilderImpl> userAttributes) {
            this.userAttributes = MapOfAttributeDimensionCopier.copyFromBuilder(userAttributes);
        }

        public SegmentDimensions build() {
            return new SegmentDimensions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SegmentDimensions> {
        public Builder attributes(Map<String, AttributeDimension> var1);

        public Builder behavior(SegmentBehaviors var1);

        default public Builder behavior(Consumer<SegmentBehaviors.Builder> behavior) {
            return this.behavior((SegmentBehaviors)((SegmentBehaviors.Builder)SegmentBehaviors.builder().apply(behavior)).build());
        }

        public Builder demographic(SegmentDemographics var1);

        default public Builder demographic(Consumer<SegmentDemographics.Builder> demographic) {
            return this.demographic((SegmentDemographics)((SegmentDemographics.Builder)SegmentDemographics.builder().apply(demographic)).build());
        }

        public Builder location(SegmentLocation var1);

        default public Builder location(Consumer<SegmentLocation.Builder> location) {
            return this.location((SegmentLocation)((SegmentLocation.Builder)SegmentLocation.builder().apply(location)).build());
        }

        public Builder userAttributes(Map<String, AttributeDimension> var1);
    }
}

