/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetSegmentImportJobsRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, GetSegmentImportJobsRequest> {
    private final String applicationId;
    private final String pageSize;
    private final String segmentId;
    private final String token;

    private GetSegmentImportJobsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.pageSize = builder.pageSize;
        this.segmentId = builder.segmentId;
        this.token = builder.token;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String pageSize() {
        return this.pageSize;
    }

    public String segmentId() {
        return this.segmentId;
    }

    public String token() {
        return this.token;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentImportJobsRequest)) {
            return false;
        }
        GetSegmentImportJobsRequest other = (GetSegmentImportJobsRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.segmentId(), other.segmentId()) && Objects.equals(this.token(), other.token());
    }

    public String toString() {
        return ToString.builder((String)"GetSegmentImportJobsRequest").add("ApplicationId", (Object)this.applicationId()).add("PageSize", (Object)this.pageSize()).add("SegmentId", (Object)this.segmentId()).add("Token", (Object)this.token()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "PageSize": {
                return Optional.of(clazz.cast(this.pageSize()));
            }
            case "SegmentId": {
                return Optional.of(clazz.cast(this.segmentId()));
            }
            case "Token": {
                return Optional.of(clazz.cast(this.token()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String pageSize;
        private String segmentId;
        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentImportJobsRequest model) {
            this.applicationId(model.applicationId);
            this.pageSize(model.pageSize);
            this.segmentId(model.segmentId);
            this.token(model.token);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(String pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetSegmentImportJobsRequest build() {
            return new GetSegmentImportJobsRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, GetSegmentImportJobsRequest> {
        public Builder applicationId(String var1);

        public Builder pageSize(String var1);

        public Builder segmentId(String var1);

        public Builder token(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

