/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.GCMChannelResponseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GCMChannelResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, GCMChannelResponse> {
    private final String applicationId;
    private final String creationDate;
    private final String credential;
    private final Boolean enabled;
    private final Boolean hasCredential;
    private final String id;
    private final Boolean isArchived;
    private final String lastModifiedBy;
    private final String lastModifiedDate;
    private final String platform;
    private final Integer version;

    private GCMChannelResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.creationDate = builder.creationDate;
        this.credential = builder.credential;
        this.enabled = builder.enabled;
        this.hasCredential = builder.hasCredential;
        this.id = builder.id;
        this.isArchived = builder.isArchived;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.platform = builder.platform;
        this.version = builder.version;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public String credential() {
        return this.credential;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Boolean hasCredential() {
        return this.hasCredential;
    }

    public String id() {
        return this.id;
    }

    public Boolean isArchived() {
        return this.isArchived;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String platform() {
        return this.platform;
    }

    public Integer version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.credential());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCredential());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GCMChannelResponse)) {
            return false;
        }
        GCMChannelResponse other = (GCMChannelResponse)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.credential(), other.credential()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.hasCredential(), other.hasCredential()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.isArchived(), other.isArchived()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"GCMChannelResponse").add("ApplicationId", (Object)this.applicationId()).add("CreationDate", (Object)this.creationDate()).add("Credential", (Object)this.credential()).add("Enabled", (Object)this.enabled()).add("HasCredential", (Object)this.hasCredential()).add("Id", (Object)this.id()).add("IsArchived", (Object)this.isArchived()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Platform", (Object)this.platform()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "Credential": {
                return Optional.of(clazz.cast(this.credential()));
            }
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "HasCredential": {
                return Optional.of(clazz.cast(this.hasCredential()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "IsArchived": {
                return Optional.of(clazz.cast(this.isArchived()));
            }
            case "LastModifiedBy": {
                return Optional.of(clazz.cast(this.lastModifiedBy()));
            }
            case "LastModifiedDate": {
                return Optional.of(clazz.cast(this.lastModifiedDate()));
            }
            case "Platform": {
                return Optional.of(clazz.cast(this.platform()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GCMChannelResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String creationDate;
        private String credential;
        private Boolean enabled;
        private Boolean hasCredential;
        private String id;
        private Boolean isArchived;
        private String lastModifiedBy;
        private String lastModifiedDate;
        private String platform;
        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(GCMChannelResponse model) {
            this.applicationId(model.applicationId);
            this.creationDate(model.creationDate);
            this.credential(model.credential);
            this.enabled(model.enabled);
            this.hasCredential(model.hasCredential);
            this.id(model.id);
            this.isArchived(model.isArchived);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedDate(model.lastModifiedDate);
            this.platform(model.platform);
            this.version(model.version);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final String getCredential() {
            return this.credential;
        }

        @Override
        public final Builder credential(String credential) {
            this.credential = credential;
            return this;
        }

        public final void setCredential(String credential) {
            this.credential = credential;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getHasCredential() {
            return this.hasCredential;
        }

        @Override
        public final Builder hasCredential(Boolean hasCredential) {
            this.hasCredential = hasCredential;
            return this;
        }

        public final void setHasCredential(Boolean hasCredential) {
            this.hasCredential = hasCredential;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Boolean getIsArchived() {
            return this.isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public GCMChannelResponse build() {
            return new GCMChannelResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GCMChannelResponse> {
        public Builder applicationId(String var1);

        public Builder creationDate(String var1);

        public Builder credential(String var1);

        public Builder enabled(Boolean var1);

        public Builder hasCredential(Boolean var1);

        public Builder id(String var1);

        public Builder isArchived(Boolean var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedDate(String var1);

        public Builder platform(String var1);

        public Builder version(Integer var1);
    }
}

