/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.EndpointLocationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EndpointLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointLocation> {
    private final String city;
    private final String country;
    private final Double latitude;
    private final Double longitude;
    private final String postalCode;
    private final String region;

    private EndpointLocation(BuilderImpl builder) {
        this.city = builder.city;
        this.country = builder.country;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
        this.postalCode = builder.postalCode;
        this.region = builder.region;
    }

    public String city() {
        return this.city;
    }

    public String country() {
        return this.country;
    }

    public Double latitude() {
        return this.latitude;
    }

    public Double longitude() {
        return this.longitude;
    }

    public String postalCode() {
        return this.postalCode;
    }

    public String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.latitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.longitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointLocation)) {
            return false;
        }
        EndpointLocation other = (EndpointLocation)obj;
        return Objects.equals(this.city(), other.city()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.latitude(), other.latitude()) && Objects.equals(this.longitude(), other.longitude()) && Objects.equals(this.postalCode(), other.postalCode()) && Objects.equals(this.region(), other.region());
    }

    public String toString() {
        return ToString.builder((String)"EndpointLocation").add("City", (Object)this.city()).add("Country", (Object)this.country()).add("Latitude", (Object)this.latitude()).add("Longitude", (Object)this.longitude()).add("PostalCode", (Object)this.postalCode()).add("Region", (Object)this.region()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "City": {
                return Optional.of(clazz.cast(this.city()));
            }
            case "Country": {
                return Optional.of(clazz.cast(this.country()));
            }
            case "Latitude": {
                return Optional.of(clazz.cast(this.latitude()));
            }
            case "Longitude": {
                return Optional.of(clazz.cast(this.longitude()));
            }
            case "PostalCode": {
                return Optional.of(clazz.cast(this.postalCode()));
            }
            case "Region": {
                return Optional.of(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String city;
        private String country;
        private Double latitude;
        private Double longitude;
        private String postalCode;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointLocation model) {
            this.city(model.city);
            this.country(model.country);
            this.latitude(model.latitude);
            this.longitude(model.longitude);
            this.postalCode(model.postalCode);
            this.region(model.region);
        }

        public final String getCity() {
            return this.city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        public final String getCountry() {
            return this.country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        public final Double getLatitude() {
            return this.latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        public final Double getLongitude() {
            return this.longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public EndpointLocation build() {
            return new EndpointLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointLocation> {
        public Builder city(String var1);

        public Builder country(String var1);

        public Builder latitude(Double var1);

        public Builder longitude(Double var1);

        public Builder postalCode(String var1);

        public Builder region(String var1);
    }
}

