/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.ADMMessage;
import software.amazon.awssdk.services.pinpoint.model.APNSMessage;
import software.amazon.awssdk.services.pinpoint.model.BaiduMessage;
import software.amazon.awssdk.services.pinpoint.model.DefaultMessage;
import software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage;
import software.amazon.awssdk.services.pinpoint.model.GCMMessage;
import software.amazon.awssdk.services.pinpoint.model.SMSMessage;
import software.amazon.awssdk.services.pinpoint.transform.DirectMessageConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DirectMessageConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, DirectMessageConfiguration> {
    private final ADMMessage admMessage;
    private final APNSMessage apnsMessage;
    private final BaiduMessage baiduMessage;
    private final DefaultMessage defaultMessage;
    private final DefaultPushNotificationMessage defaultPushNotificationMessage;
    private final GCMMessage gcmMessage;
    private final SMSMessage smsMessage;

    private DirectMessageConfiguration(BuilderImpl builder) {
        this.admMessage = builder.admMessage;
        this.apnsMessage = builder.apnsMessage;
        this.baiduMessage = builder.baiduMessage;
        this.defaultMessage = builder.defaultMessage;
        this.defaultPushNotificationMessage = builder.defaultPushNotificationMessage;
        this.gcmMessage = builder.gcmMessage;
        this.smsMessage = builder.smsMessage;
    }

    public ADMMessage admMessage() {
        return this.admMessage;
    }

    public APNSMessage apnsMessage() {
        return this.apnsMessage;
    }

    public BaiduMessage baiduMessage() {
        return this.baiduMessage;
    }

    public DefaultMessage defaultMessage() {
        return this.defaultMessage;
    }

    public DefaultPushNotificationMessage defaultPushNotificationMessage() {
        return this.defaultPushNotificationMessage;
    }

    public GCMMessage gcmMessage() {
        return this.gcmMessage;
    }

    public SMSMessage smsMessage() {
        return this.smsMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.admMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.apnsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.baiduMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultPushNotificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.gcmMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectMessageConfiguration)) {
            return false;
        }
        DirectMessageConfiguration other = (DirectMessageConfiguration)obj;
        return Objects.equals(this.admMessage(), other.admMessage()) && Objects.equals(this.apnsMessage(), other.apnsMessage()) && Objects.equals(this.baiduMessage(), other.baiduMessage()) && Objects.equals(this.defaultMessage(), other.defaultMessage()) && Objects.equals(this.defaultPushNotificationMessage(), other.defaultPushNotificationMessage()) && Objects.equals(this.gcmMessage(), other.gcmMessage()) && Objects.equals(this.smsMessage(), other.smsMessage());
    }

    public String toString() {
        return ToString.builder((String)"DirectMessageConfiguration").add("ADMMessage", (Object)this.admMessage()).add("APNSMessage", (Object)this.apnsMessage()).add("BaiduMessage", (Object)this.baiduMessage()).add("DefaultMessage", (Object)this.defaultMessage()).add("DefaultPushNotificationMessage", (Object)this.defaultPushNotificationMessage()).add("GCMMessage", (Object)this.gcmMessage()).add("SMSMessage", (Object)this.smsMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ADMMessage": {
                return Optional.of(clazz.cast(this.admMessage()));
            }
            case "APNSMessage": {
                return Optional.of(clazz.cast(this.apnsMessage()));
            }
            case "BaiduMessage": {
                return Optional.of(clazz.cast(this.baiduMessage()));
            }
            case "DefaultMessage": {
                return Optional.of(clazz.cast(this.defaultMessage()));
            }
            case "DefaultPushNotificationMessage": {
                return Optional.of(clazz.cast(this.defaultPushNotificationMessage()));
            }
            case "GCMMessage": {
                return Optional.of(clazz.cast(this.gcmMessage()));
            }
            case "SMSMessage": {
                return Optional.of(clazz.cast(this.smsMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DirectMessageConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ADMMessage admMessage;
        private APNSMessage apnsMessage;
        private BaiduMessage baiduMessage;
        private DefaultMessage defaultMessage;
        private DefaultPushNotificationMessage defaultPushNotificationMessage;
        private GCMMessage gcmMessage;
        private SMSMessage smsMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectMessageConfiguration model) {
            this.admMessage(model.admMessage);
            this.apnsMessage(model.apnsMessage);
            this.baiduMessage(model.baiduMessage);
            this.defaultMessage(model.defaultMessage);
            this.defaultPushNotificationMessage(model.defaultPushNotificationMessage);
            this.gcmMessage(model.gcmMessage);
            this.smsMessage(model.smsMessage);
        }

        public final ADMMessage.Builder getADMMessage() {
            return this.admMessage != null ? this.admMessage.toBuilder() : null;
        }

        @Override
        public final Builder admMessage(ADMMessage admMessage) {
            this.admMessage = admMessage;
            return this;
        }

        public final void setADMMessage(ADMMessage.BuilderImpl admMessage) {
            this.admMessage = admMessage != null ? admMessage.build() : null;
        }

        public final APNSMessage.Builder getAPNSMessage() {
            return this.apnsMessage != null ? this.apnsMessage.toBuilder() : null;
        }

        @Override
        public final Builder apnsMessage(APNSMessage apnsMessage) {
            this.apnsMessage = apnsMessage;
            return this;
        }

        public final void setAPNSMessage(APNSMessage.BuilderImpl apnsMessage) {
            this.apnsMessage = apnsMessage != null ? apnsMessage.build() : null;
        }

        public final BaiduMessage.Builder getBaiduMessage() {
            return this.baiduMessage != null ? this.baiduMessage.toBuilder() : null;
        }

        @Override
        public final Builder baiduMessage(BaiduMessage baiduMessage) {
            this.baiduMessage = baiduMessage;
            return this;
        }

        public final void setBaiduMessage(BaiduMessage.BuilderImpl baiduMessage) {
            this.baiduMessage = baiduMessage != null ? baiduMessage.build() : null;
        }

        public final DefaultMessage.Builder getDefaultMessage() {
            return this.defaultMessage != null ? this.defaultMessage.toBuilder() : null;
        }

        @Override
        public final Builder defaultMessage(DefaultMessage defaultMessage) {
            this.defaultMessage = defaultMessage;
            return this;
        }

        public final void setDefaultMessage(DefaultMessage.BuilderImpl defaultMessage) {
            this.defaultMessage = defaultMessage != null ? defaultMessage.build() : null;
        }

        public final DefaultPushNotificationMessage.Builder getDefaultPushNotificationMessage() {
            return this.defaultPushNotificationMessage != null ? this.defaultPushNotificationMessage.toBuilder() : null;
        }

        @Override
        public final Builder defaultPushNotificationMessage(DefaultPushNotificationMessage defaultPushNotificationMessage) {
            this.defaultPushNotificationMessage = defaultPushNotificationMessage;
            return this;
        }

        public final void setDefaultPushNotificationMessage(DefaultPushNotificationMessage.BuilderImpl defaultPushNotificationMessage) {
            this.defaultPushNotificationMessage = defaultPushNotificationMessage != null ? defaultPushNotificationMessage.build() : null;
        }

        public final GCMMessage.Builder getGCMMessage() {
            return this.gcmMessage != null ? this.gcmMessage.toBuilder() : null;
        }

        @Override
        public final Builder gcmMessage(GCMMessage gcmMessage) {
            this.gcmMessage = gcmMessage;
            return this;
        }

        public final void setGCMMessage(GCMMessage.BuilderImpl gcmMessage) {
            this.gcmMessage = gcmMessage != null ? gcmMessage.build() : null;
        }

        public final SMSMessage.Builder getSMSMessage() {
            return this.smsMessage != null ? this.smsMessage.toBuilder() : null;
        }

        @Override
        public final Builder smsMessage(SMSMessage smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final void setSMSMessage(SMSMessage.BuilderImpl smsMessage) {
            this.smsMessage = smsMessage != null ? smsMessage.build() : null;
        }

        public DirectMessageConfiguration build() {
            return new DirectMessageConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DirectMessageConfiguration> {
        public Builder admMessage(ADMMessage var1);

        default public Builder admMessage(Consumer<ADMMessage.Builder> admMessage) {
            return this.admMessage((ADMMessage)((ADMMessage.Builder)ADMMessage.builder().apply(admMessage)).build());
        }

        public Builder apnsMessage(APNSMessage var1);

        default public Builder apnsMessage(Consumer<APNSMessage.Builder> apnsMessage) {
            return this.apnsMessage((APNSMessage)((APNSMessage.Builder)APNSMessage.builder().apply(apnsMessage)).build());
        }

        public Builder baiduMessage(BaiduMessage var1);

        default public Builder baiduMessage(Consumer<BaiduMessage.Builder> baiduMessage) {
            return this.baiduMessage((BaiduMessage)((BaiduMessage.Builder)BaiduMessage.builder().apply(baiduMessage)).build());
        }

        public Builder defaultMessage(DefaultMessage var1);

        default public Builder defaultMessage(Consumer<DefaultMessage.Builder> defaultMessage) {
            return this.defaultMessage((DefaultMessage)((DefaultMessage.Builder)DefaultMessage.builder().apply(defaultMessage)).build());
        }

        public Builder defaultPushNotificationMessage(DefaultPushNotificationMessage var1);

        default public Builder defaultPushNotificationMessage(Consumer<DefaultPushNotificationMessage.Builder> defaultPushNotificationMessage) {
            return this.defaultPushNotificationMessage((DefaultPushNotificationMessage)((DefaultPushNotificationMessage.Builder)DefaultPushNotificationMessage.builder().apply(defaultPushNotificationMessage)).build());
        }

        public Builder gcmMessage(GCMMessage var1);

        default public Builder gcmMessage(Consumer<GCMMessage.Builder> gcmMessage) {
            return this.gcmMessage((GCMMessage)((GCMMessage.Builder)GCMMessage.builder().apply(gcmMessage)).build());
        }

        public Builder smsMessage(SMSMessage var1);

        default public Builder smsMessage(Consumer<SMSMessage.Builder> smsMessage) {
            return this.smsMessage((SMSMessage)((SMSMessage.Builder)SMSMessage.builder().apply(smsMessage)).build());
        }
    }
}

