/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.SegmentImportResource;

@SdkInternalApi
public class SegmentImportResourceMarshaller {
    private static final MarshallingInfo<Map> CHANNELCOUNTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChannelCounts").build();
    private static final MarshallingInfo<String> EXTERNALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalId").build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Format").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<String> S3URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Url").build();
    private static final MarshallingInfo<Integer> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").build();
    private static final SegmentImportResourceMarshaller INSTANCE = new SegmentImportResourceMarshaller();

    public static SegmentImportResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SegmentImportResource segmentImportResource, ProtocolMarshaller protocolMarshaller) {
        if (segmentImportResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(segmentImportResource.channelCounts(), CHANNELCOUNTS_BINDING);
            protocolMarshaller.marshall((Object)segmentImportResource.externalId(), EXTERNALID_BINDING);
            protocolMarshaller.marshall((Object)segmentImportResource.formatString(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)segmentImportResource.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)segmentImportResource.s3Url(), S3URL_BINDING);
            protocolMarshaller.marshall((Object)segmentImportResource.size(), SIZE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

