/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.MessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.Schedule;
import software.amazon.awssdk.services.pinpoint.transform.WriteTreatmentResourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WriteTreatmentResource
implements StructuredPojo,
ToCopyableBuilder<Builder, WriteTreatmentResource> {
    private final MessageConfiguration messageConfiguration;
    private final Schedule schedule;
    private final Integer sizePercent;
    private final String treatmentDescription;
    private final String treatmentName;

    private WriteTreatmentResource(BuilderImpl builder) {
        this.messageConfiguration = builder.messageConfiguration;
        this.schedule = builder.schedule;
        this.sizePercent = builder.sizePercent;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
    }

    public MessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public Integer sizePercent() {
        return this.sizePercent;
    }

    public String treatmentDescription() {
        return this.treatmentDescription;
    }

    public String treatmentName() {
        return this.treatmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.messageConfiguration() == null ? 0 : this.messageConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.schedule() == null ? 0 : this.schedule().hashCode());
        hashCode = 31 * hashCode + (this.sizePercent() == null ? 0 : this.sizePercent().hashCode());
        hashCode = 31 * hashCode + (this.treatmentDescription() == null ? 0 : this.treatmentDescription().hashCode());
        hashCode = 31 * hashCode + (this.treatmentName() == null ? 0 : this.treatmentName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteTreatmentResource)) {
            return false;
        }
        WriteTreatmentResource other = (WriteTreatmentResource)obj;
        if (other.messageConfiguration() == null ^ this.messageConfiguration() == null) {
            return false;
        }
        if (other.messageConfiguration() != null && !other.messageConfiguration().equals(this.messageConfiguration())) {
            return false;
        }
        if (other.schedule() == null ^ this.schedule() == null) {
            return false;
        }
        if (other.schedule() != null && !other.schedule().equals(this.schedule())) {
            return false;
        }
        if (other.sizePercent() == null ^ this.sizePercent() == null) {
            return false;
        }
        if (other.sizePercent() != null && !other.sizePercent().equals(this.sizePercent())) {
            return false;
        }
        if (other.treatmentDescription() == null ^ this.treatmentDescription() == null) {
            return false;
        }
        if (other.treatmentDescription() != null && !other.treatmentDescription().equals(this.treatmentDescription())) {
            return false;
        }
        if (other.treatmentName() == null ^ this.treatmentName() == null) {
            return false;
        }
        return other.treatmentName() == null || other.treatmentName().equals(this.treatmentName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.messageConfiguration() != null) {
            sb.append("MessageConfiguration: ").append(this.messageConfiguration()).append(",");
        }
        if (this.schedule() != null) {
            sb.append("Schedule: ").append(this.schedule()).append(",");
        }
        if (this.sizePercent() != null) {
            sb.append("SizePercent: ").append(this.sizePercent()).append(",");
        }
        if (this.treatmentDescription() != null) {
            sb.append("TreatmentDescription: ").append(this.treatmentDescription()).append(",");
        }
        if (this.treatmentName() != null) {
            sb.append("TreatmentName: ").append(this.treatmentName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageConfiguration": {
                return Optional.of(clazz.cast(this.messageConfiguration()));
            }
            case "Schedule": {
                return Optional.of(clazz.cast(this.schedule()));
            }
            case "SizePercent": {
                return Optional.of(clazz.cast(this.sizePercent()));
            }
            case "TreatmentDescription": {
                return Optional.of(clazz.cast(this.treatmentDescription()));
            }
            case "TreatmentName": {
                return Optional.of(clazz.cast(this.treatmentName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WriteTreatmentResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private MessageConfiguration messageConfiguration;
        private Schedule schedule;
        private Integer sizePercent;
        private String treatmentDescription;
        private String treatmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteTreatmentResource model) {
            this.messageConfiguration(model.messageConfiguration);
            this.schedule(model.schedule);
            this.sizePercent(model.sizePercent);
            this.treatmentDescription(model.treatmentDescription);
            this.treatmentName(model.treatmentName);
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return this.messageConfiguration != null ? this.messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final Integer getSizePercent() {
            return this.sizePercent;
        }

        @Override
        public final Builder sizePercent(Integer sizePercent) {
            this.sizePercent = sizePercent;
            return this;
        }

        public final void setSizePercent(Integer sizePercent) {
            this.sizePercent = sizePercent;
        }

        public final String getTreatmentDescription() {
            return this.treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        public final String getTreatmentName() {
            return this.treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        public WriteTreatmentResource build() {
            return new WriteTreatmentResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WriteTreatmentResource> {
        public Builder messageConfiguration(MessageConfiguration var1);

        public Builder schedule(Schedule var1);

        public Builder sizePercent(Integer var1);

        public Builder treatmentDescription(String var1);

        public Builder treatmentName(String var1);
    }
}

