/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.QuietTimeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class QuietTime
implements StructuredPojo,
ToCopyableBuilder<Builder, QuietTime> {
    private final String end;
    private final String start;

    private QuietTime(BuilderImpl builder) {
        this.end = builder.end;
        this.start = builder.start;
    }

    public String end() {
        return this.end;
    }

    public String start() {
        return this.start;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.end() == null ? 0 : this.end().hashCode());
        hashCode = 31 * hashCode + (this.start() == null ? 0 : this.start().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuietTime)) {
            return false;
        }
        QuietTime other = (QuietTime)obj;
        if (other.end() == null ^ this.end() == null) {
            return false;
        }
        if (other.end() != null && !other.end().equals(this.end())) {
            return false;
        }
        if (other.start() == null ^ this.start() == null) {
            return false;
        }
        return other.start() == null || other.start().equals(this.start());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.end() != null) {
            sb.append("End: ").append(this.end()).append(",");
        }
        if (this.start() != null) {
            sb.append("Start: ").append(this.start()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "End": {
                return Optional.of(clazz.cast(this.end()));
            }
            case "Start": {
                return Optional.of(clazz.cast(this.start()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QuietTimeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String end;
        private String start;

        private BuilderImpl() {
        }

        private BuilderImpl(QuietTime model) {
            this.end(model.end);
            this.start(model.start);
        }

        public final String getEnd() {
            return this.end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        public final String getStart() {
            return this.start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        public QuietTime build() {
            return new QuietTime(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QuietTime> {
        public Builder end(String var1);

        public Builder start(String var1);
    }
}

